/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.controller.service;

import lombok.Generated;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.model.KeywordsModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.pagination.ComplexPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.pagination.DefaultUserFilter;
import org.youngmonkeys.ezyplatform.pagination.PaginationModelFetchers;
import org.youngmonkeys.ezyplatform.pagination.UserPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.service.PaginationService;
import org.youngmonkeys.ezyplatform.service.PaginationUserService;
import org.youngmonkeys.ezyplatform.util.StringConverters;

public class UserControllerService {
    private final PaginationUserService paginationUserService;
    private final UserPaginationParameterConverter userPaginationParameterConverter;

    public PaginationModel<UserModel> getUserPagination(String keyword, boolean allowSearchUserByLikeOperator, DefaultUserFilter.Builder<?> filterBuilder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        return this.getUserPagination(keyword, allowSearchUserByLikeOperator, filterBuilder, CommonConstants.NULL_STRING, nextPageToken, prevPageToken, lastPage, limit);
    }

    public PaginationModel<UserModel> getUserPagination(String keyword, boolean allowSearchUserByLikeOperator, DefaultUserFilter.Builder<?> filterBuilder, String sortOrder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        PaginationModel pagination = PaginationModel.emptyPagination();
        String nullableKeyword = StringConverters.trimOrNull((String)keyword);
        if (nullableKeyword == null) {
            pagination = PaginationModelFetchers.getPaginationModelBySortOrder((PaginationService)this.paginationUserService, (ComplexPaginationParameterConverter)this.userPaginationParameterConverter, (Object)filterBuilder.build(), (String)sortOrder, (String)nextPageToken, (String)prevPageToken, (boolean)lastPage, (int)limit);
        }
        if (nullableKeyword != null && (pagination = PaginationModelFetchers.getPaginationModelBySortOrder((PaginationService)this.paginationUserService, (ComplexPaginationParameterConverter)this.userPaginationParameterConverter, (Object)((DefaultUserFilter.Builder)filterBuilder.uniqueKeyword(nullableKeyword)).build(), (String)sortOrder, (String)nextPageToken, (String)prevPageToken, (boolean)lastPage, (int)limit)).getCount() == 0) {
            KeywordsModel keywords = KeywordsModel.extract((String)keyword, (boolean)allowSearchUserByLikeOperator);
            pagination = PaginationModelFetchers.getPaginationModelBySortOrder((PaginationService)this.paginationUserService, (ComplexPaginationParameterConverter)this.userPaginationParameterConverter, (Object)((DefaultUserFilter.Builder)((DefaultUserFilter.Builder)((DefaultUserFilter.Builder)filterBuilder.uniqueKeyword(CommonConstants.NULL_STRING)).likeKeyword(keywords.getLikeKeyword())).keywords(keywords.getKeywords())).build(), (String)sortOrder, (String)nextPageToken, (String)prevPageToken, (boolean)lastPage, (int)limit);
        }
        return pagination;
    }

    @Generated
    public UserControllerService(PaginationUserService paginationUserService, UserPaginationParameterConverter userPaginationParameterConverter) {
        this.paginationUserService = paginationUserService;
        this.userPaginationParameterConverter = userPaginationParameterConverter;
    }
}

