/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.monitor;

import com.tvd12.ezyfox.monitor.data.EzyThreadDetail;
import com.tvd12.ezyfox.monitor.data.EzyThreadDetails;
import com.tvd12.ezyfox.monitor.data.EzyThreadsDetail;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;

public class EzyThreadsMonitor {
    public int getThreadCount() {
        ThreadMXBean tmxBean = this.getThreadMXBean();
        return tmxBean.getThreadCount();
    }

    public int getDaemonThreadCount() {
        ThreadMXBean tmxBean = this.getThreadMXBean();
        return tmxBean.getDaemonThreadCount();
    }

    public EzyThreadDetails getThreadDetails(long threadId) {
        ThreadMXBean tmxBean = this.getThreadMXBean();
        ThreadInfo info = tmxBean.getThreadInfo(threadId);
        if (info == null) {
            return null;
        }
        return new EzyThreadDetails(info);
    }

    public EzyThreadsDetail getThreadsDetails() {
        long totalThreadsCpuTime = 0L;
        ThreadMXBean tmxBean = this.getThreadMXBean();
        long[] threadIds = tmxBean.getAllThreadIds();
        ArrayList<EzyThreadDetail> threads = new ArrayList<EzyThreadDetail>();
        for (long threadId : threadIds) {
            ThreadInfo threadInfo = tmxBean.getThreadInfo(threadId);
            if (threadInfo == null) continue;
            String threadName = threadInfo.getThreadName();
            long cpuTime = 0L;
            if (this.canGetThreadCpuTime() && (cpuTime = tmxBean.getThreadCpuTime(threadId)) > 0L) {
                totalThreadsCpuTime += cpuTime;
            }
            EzyThreadDetail detail = EzyThreadDetail.builder().id(threadId).name(threadName).cpuTime(cpuTime).build();
            threads.add(detail);
        }
        return EzyThreadsDetail.builder().threads(threads).totalThreadsCpuTime(totalThreadsCpuTime).build();
    }

    protected boolean canGetThreadCpuTime() {
        return this.isThreadCpuTimeEnabled() && this.isThreadCpuTimeSupported();
    }

    protected boolean isThreadCpuTimeEnabled() {
        return this.getThreadMXBean().isThreadCpuTimeEnabled();
    }

    protected boolean isThreadCpuTimeSupported() {
        return this.getThreadMXBean().isThreadCpuTimeSupported();
    }

    protected ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }
}

