/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.codec;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.codec.EzyCodecCreator;
import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfoxserver.codec.EzyCodecFactory;
import com.tvd12.ezyfoxserver.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.setting.EzySocketSetting;
import com.tvd12.ezyfoxserver.setting.EzyWebSocketSetting;

public class EzySimpleCodecFactory
implements EzyCodecFactory {
    protected final EzySocketSetting socketSetting;
    protected final EzyWebSocketSetting websocketSetting;
    protected final EzyCodecCreator socketCodecCreator;
    protected final EzyCodecCreator websocketCodecCreator;

    public EzySimpleCodecFactory(Builder builder) {
        this.socketSetting = builder.socketSetting;
        this.websocketSetting = builder.websocketSetting;
        this.socketCodecCreator = this.newSocketCodecCreator();
        this.websocketCodecCreator = this.newWebsocketCodecCreator();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object newEncoder(EzyConstant type) {
        if (type == EzyConnectionType.SOCKET) {
            if (this.socketCodecCreator != null) {
                return this.socketCodecCreator.newEncoder();
            }
        } else if (this.websocketCodecCreator != null) {
            return this.websocketCodecCreator.newEncoder();
        }
        return null;
    }

    @Override
    public Object newDecoder(EzyConstant type) {
        if (type == EzyConnectionType.SOCKET) {
            if (this.socketCodecCreator != null) {
                int maxRequestSize = this.socketSetting.getMaxRequestSize();
                return this.socketCodecCreator.newDecoder(maxRequestSize);
            }
        } else if (this.websocketCodecCreator != null) {
            int maxFrameSize = this.websocketSetting.getMaxFrameSize();
            return this.websocketCodecCreator.newDecoder(maxFrameSize);
        }
        return null;
    }

    private EzyCodecCreator newSocketCodecCreator() {
        if (this.socketSetting.isActive()) {
            return (EzyCodecCreator)EzyClasses.newInstance((String)this.socketSetting.getCodecCreator(), (Class[])new Class[]{Boolean.TYPE}, (Object[])new Object[]{this.socketSetting.isSslActive()});
        }
        return null;
    }

    private EzyCodecCreator newWebsocketCodecCreator() {
        if (this.websocketSetting.isActive()) {
            return (EzyCodecCreator)EzyClasses.newInstance((String)this.websocketSetting.getCodecCreator());
        }
        return null;
    }

    public static class Builder
    implements EzyBuilder<EzyCodecFactory> {
        protected EzySocketSetting socketSetting;
        protected EzyWebSocketSetting websocketSetting;

        public Builder socketSetting(EzySocketSetting settings) {
            this.socketSetting = settings;
            return this;
        }

        public Builder websocketSetting(EzyWebSocketSetting settings) {
            this.websocketSetting = settings;
            return this;
        }

        public EzyCodecFactory build() {
            return new EzySimpleCodecFactory(this);
        }
    }
}

