/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyRoundRobin;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;

public class EzyDatagramChannelPool
extends EzyLoggable {
    protected final EzyRoundRobin<DatagramChannel> channels;

    public EzyDatagramChannelPool(int poolSize) {
        this.channels = new EzyRoundRobin(this::newChannel, poolSize);
    }

    protected DatagramChannel newChannel() {
        try {
            DatagramChannel channel = this.openChannel();
            channel.configureBlocking(false);
            channel.socket().setReuseAddress(true);
            return channel;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    protected DatagramChannel openChannel() throws IOException {
        return DatagramChannel.open();
    }

    public void bind(InetSocketAddress address) {
        this.channels.forEach(channel -> {
            try {
                channel.bind(address);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void register(Selector selector) {
        this.channels.forEach(channel -> {
            try {
                channel.register(selector, 1);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public DatagramChannel getChannel() {
        return (DatagramChannel)this.channels.get();
    }

    public void close() {
        this.channels.forEach(channel -> {
            try {
                channel.close();
            }
            catch (Throwable e) {
                this.logger.warn("close datagram channel: {} error", channel, (Object)e);
            }
        });
    }
}

