/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.rx;

import com.tvd12.ezyfox.concurrent.EzyExecutors;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.rx.RxConsumer;
import org.youngmonkeys.ezyplatform.rx.RxException;
import org.youngmonkeys.ezyplatform.rx.RxFunction;
import org.youngmonkeys.ezyplatform.rx.RxMultiple;
import org.youngmonkeys.ezyplatform.rx.RxOperation;
import org.youngmonkeys.ezyplatform.rx.RxOperationSupplier;
import org.youngmonkeys.ezyplatform.rx.RxReturnType;
import org.youngmonkeys.ezyplatform.rx.RxRunnable;
import org.youngmonkeys.ezyplatform.rx.RxSingle;
import org.youngmonkeys.ezyplatform.rx.RxSupplier;
import org.youngmonkeys.ezyplatform.rx.RxValueMap;

public final class Reactive {
    private static ExecutorService executorService;
    private static final int DEFAULT_TIMEOUT_SECONDS = 15;
    private static final int NUMBER_OF_THREADS;
    private static final AtomicInteger NUMBER_OF_BUSY_THREADS;

    private Reactive() {
    }

    public static <T> Single<T> single(T value) {
        return new Single<T>(value);
    }

    public static <T> Single<T> single(Collection<T> values) {
        return new Single<T>(values);
    }

    public static Multiple multiple() {
        return new Multiple();
    }

    public static Multiple multiple(RxReturnType returnType) {
        return new Multiple(returnType);
    }

    public static void destroy() {
        executorService.shutdown();
    }

    public static void setExecutorService(ExecutorService executorService) {
        Reactive.executorService = executorService;
    }

    static {
        NUMBER_OF_THREADS = Runtime.getRuntime().availableProcessors();
        NUMBER_OF_BUSY_THREADS = new AtomicInteger();
        executorService = EzyExecutors.newFixedThreadPool((int)NUMBER_OF_THREADS, (String)"reactive");
    }

    private static class InternalTask {
        private final Object taskKey;
        private final RxSupplier supplier;
        private final ResultValueMap resultMap;
        private final AtomicBoolean done;

        private InternalTask(ResultValueMap resultMap, Object taskKey, RxSupplier supplier) {
            this.taskKey = taskKey;
            this.supplier = supplier;
            this.resultMap = resultMap;
            this.done = new AtomicBoolean();
        }
    }

    private static class MultipleTask {
        private final ResultValueMap resultMap;
        private final Set<Map.Entry<Object, Object>> taskEntries;

        private MultipleTask(ResultValueMap resultMap, Set<Map.Entry<Object, Object>> taskEntries) {
            this.resultMap = resultMap;
            this.taskEntries = taskEntries;
        }
    }

    private static class ResultValueMap
    implements RxValueMap {
        private final List<Object> taskKeys;
        private final List<RxFunction> mappers;
        private final Map<Object, Object> map;
        private final RxReturnType returnType;

        private ResultValueMap(List<Object> taskKeys, RxReturnType returnType, List<RxFunction> mappers) {
            this.mappers = mappers;
            this.taskKeys = taskKeys;
            this.returnType = returnType;
            this.map = new ConcurrentHashMap<Object, Object>(taskKeys.size());
        }

        private void put(Object key, Object value) {
            this.map.put(key, value);
        }

        @Override
        public <T> T get(Object key) {
            return (T)this.map.get(key);
        }

        @Override
        public <T> T get(Object key, T defaultValue) {
            return (T)this.map.getOrDefault(key, defaultValue);
        }

        @Override
        public <T> T firstValue() {
            return (T)this.map.get(this.taskKeys.get(0));
        }

        @Override
        public <T> T firstValueOrNull() {
            return this.isEmpty() ? null : (T)this.firstValue();
        }

        @Override
        public <T> List<T> valueList() {
            ArrayList<Object> answer = new ArrayList<Object>();
            for (Object taskKey : this.taskKeys) {
                answer.add(this.map.get(taskKey));
            }
            return answer;
        }

        @Override
        public <T> Set<T> valueSet() {
            return new HashSet<Object>(this.map.values());
        }

        @Override
        public Map<String, Object> valueMap() {
            return this.map;
        }

        @Override
        public <K, V> Map<K, V> typedValueMap() {
            return this.map;
        }

        @Override
        public <T> T castGet() {
            if (this.returnType == RxReturnType.FIST) {
                return this.firstValue();
            }
            if (this.returnType == RxReturnType.FIST_OR_NULL) {
                return this.firstValueOrNull();
            }
            if (this.returnType == RxReturnType.LIST) {
                return (T)this.valueList();
            }
            if (this.returnType == RxReturnType.SET) {
                return (T)this.valueSet();
            }
            if (this.returnType == RxReturnType.MAP) {
                return (T)this.map;
            }
            ResultValueMap finalResult = this;
            if (this.mappers != null) {
                for (RxFunction mapperItem : this.mappers) {
                    try {
                        finalResult = mapperItem.apply(finalResult);
                    }
                    catch (Exception e) {
                        throw new RxException(e);
                    }
                }
            }
            return (T)finalResult;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }
    }

    public static class Multiple
    extends RxComponent<Multiple>
    implements RxMultiple {
        private List<RxFunction> mappers;
        private final List<Object> taskKeys = new ArrayList<Object>();
        private final Map<Object, Object> tasks = new HashMap<Object, Object>();

        public Multiple() {
            this(RxReturnType.DEFAULT);
        }

        public Multiple(RxReturnType returnType) {
            super(returnType);
        }

        public Multiple register(RxSupplier supplier) {
            return this.register(supplier, supplier);
        }

        public Multiple register(Object name, RxSupplier supplier) {
            this.taskKeys.add(name);
            this.tasks.put(name, supplier);
            return this;
        }

        public Multiple registerRx(Object name, RxOperation operation) {
            if (operation != null) {
                this.taskKeys.add(name);
                this.tasks.put(name, operation);
            }
            return this;
        }

        public Multiple registerOperation(RxRunnable operation) {
            return this.registerOperation(operation, operation);
        }

        public Multiple registerOperation(Object name, RxRunnable operation) {
            return this.register(name, () -> {
                operation.run();
                return null;
            });
        }

        public <T> Multiple registersRx(Collection<T> values, RxOperationSupplier<T> itemOperationSupplier) {
            for (T value : values) {
                this.registerRx(value, (RxOperation)itemOperationSupplier.apply(value));
            }
            return this;
        }

        public <T, R> Multiple registers(Collection<T> values, RxFunction<T, R> itemMapper) {
            values.forEach(it -> this.register(it, () -> itemMapper.apply(it)));
            return this;
        }

        public <T> Multiple registerConsumers(Collection<T> values, RxConsumer<T> itemConsumer) {
            return this.registers(values, it -> {
                itemConsumer.accept(it);
                return null;
            });
        }

        @Override
        public <R> Multiple mapBegin(RxFunction<RxValueMap, R> mapper) {
            return this.map((RxFunction)mapper);
        }

        @Override
        public <T, R> Multiple map(RxFunction<T, R> mapper) {
            if (this.returnType != RxReturnType.DEFAULT) {
                throw new IllegalArgumentException("can not set the both returnType != DEFAULT and mapper");
            }
            if (this.mappers == null) {
                this.mappers = new ArrayList<RxFunction>();
            }
            this.mappers.add(mapper);
            return this;
        }

        @Override
        public void blockingExecute() {
            this.blockingGet();
        }

        @Override
        public void blockingConsume(RxConsumer<RxValueMap> consumer) {
            this.blockingGet(it -> {
                consumer.accept((RxValueMap)it);
                return null;
            });
        }

        @Override
        public <T> T blockingGet() {
            return this.blockingGet(15, TimeUnit.SECONDS);
        }

        @Override
        public <T> T blockingGet(RxFunction<RxValueMap, T> mapper) {
            return this.blockingGet(mapper, 15, TimeUnit.SECONDS);
        }

        @Override
        public <T> T blockingGet(RxFunction<RxValueMap, T> mapper, int timeout, TimeUnit timeUnit) {
            this.map((RxFunction)mapper);
            return this.blockingGet(timeout, timeUnit);
        }

        @Override
        public <T> T blockingGet(int timeout, TimeUnit timeUnit) {
            if (this.tasks.isEmpty()) {
                return new ResultValueMap(this.taskKeys, this.returnType, this.mappers).castGet();
            }
            ResultValueMap result = new ResultValueMap(this.taskKeys, this.returnType, this.mappers);
            List<InternalTask> flattenTasks = this.flatTasks(result);
            CopyOnWriteArrayList<Exception> exceptions = new CopyOnWriteArrayList<Exception>();
            CountDownLatch countDown = new CountDownLatch(flattenTasks.size());
            for (InternalTask task : flattenTasks) {
                int busyThreads = NUMBER_OF_BUSY_THREADS.getAndUpdate(v -> v == NUMBER_OF_THREADS ? v : v + 1);
                if (busyThreads < NUMBER_OF_THREADS) {
                    executorService.execute(() -> {
                        try {
                            this.executeTask(task, exceptions, countDown);
                        }
                        finally {
                            NUMBER_OF_BUSY_THREADS.decrementAndGet();
                        }
                    });
                    continue;
                }
                this.executeTask(task, exceptions, countDown);
            }
            try {
                if (!countDown.await(timeout, timeUnit)) {
                    exceptions.add(new TimeoutException("timeout, maybe some tasks undone: " + this.getUndoneTaskKeys(flattenTasks)));
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            if (exceptions.isEmpty()) {
                this.convertRxMapValues(result);
                return result.castGet();
            }
            throw new RxException(exceptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeTask(InternalTask task, List<Exception> exceptions, CountDownLatch countDown) {
            try {
                Object value = task.supplier.get();
                if (value != null) {
                    task.resultMap.put(task.taskKey, value);
                    task.done.set(true);
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            finally {
                countDown.countDown();
            }
        }

        private List<InternalTask> flatTasks(ResultValueMap rootValueMap) {
            ResultValueMap parentResultMap = rootValueMap;
            ArrayList<InternalTask> flattenTasks = new ArrayList<InternalTask>();
            LinkedList<MultipleTask> taskQueue = new LinkedList<MultipleTask>();
            Set taskEntries = this.tasks.entrySet();
            while (true) {
                for (Map.Entry<Object, Object> e : taskEntries) {
                    Object taskKey = e.getKey();
                    Object task = e.getValue();
                    if (task instanceof RxSupplier) {
                        flattenTasks.add(new InternalTask(parentResultMap, taskKey, (RxSupplier)task));
                        continue;
                    }
                    Multiple multiple = task instanceof Multiple ? (Multiple)task : ((Single)task).toMultiple();
                    ResultValueMap resultMap = new ResultValueMap(multiple.taskKeys, multiple.returnType, multiple.mappers);
                    parentResultMap.put(taskKey, resultMap);
                    taskQueue.offer(new MultipleTask(resultMap, multiple.tasks.entrySet()));
                }
                MultipleTask multipleTask = (MultipleTask)taskQueue.poll();
                if (multipleTask == null) break;
                parentResultMap = multipleTask.resultMap;
                taskEntries = multipleTask.taskEntries;
            }
            return flattenTasks;
        }

        private List<Object> getUndoneTaskKeys(List<InternalTask> tasks) {
            return tasks.stream().filter(it -> !((InternalTask)it).done.get()).map((? super T it) -> ((InternalTask)it).taskKey).collect(Collectors.toList());
        }

        private void convertRxMapValues(ResultValueMap rootValueMap) {
            ArrayDeque<Object> stack = new ArrayDeque<Object>();
            ResultValueMap resultMap = rootValueMap;
            while (true) {
                int rxMapCount = 0;
                for (Map.Entry e : resultMap.map.entrySet()) {
                    Object value = e.getValue();
                    if (!(value instanceof RxValueMap)) continue;
                    stack.push(resultMap);
                    stack.push(e);
                    ++rxMapCount;
                }
                if (rxMapCount == 0 && !stack.isEmpty()) {
                    Object taskKey = ((Map.Entry)stack.pop()).getKey();
                    ResultValueMap parent = (ResultValueMap)stack.pop();
                    parent.put(taskKey, resultMap.castGet());
                }
                if (stack.isEmpty()) break;
                resultMap = (ResultValueMap)((Map.Entry)stack.peek()).getValue();
            }
        }
    }

    public static class Single<T>
    extends RxComponent<Single<T>>
    implements RxSingle<T> {
        private final List<T> firstValues;
        private List<RxFunction> itemMappers;
        private RxOperationSupplier<T> itemOperationSupplier;

        public Single(T value) {
            this(Collections.singletonList(value), RxReturnType.FIST_OR_NULL);
        }

        public Single(Collection<T> values) {
            this(values, RxReturnType.LIST);
        }

        public Single(Collection<T> values, RxReturnType returnType) {
            super(returnType);
            this.firstValues = new ArrayList<T>(values);
        }

        @Override
        public <R> Single<R> mapItem(RxFunction<T, R> mapper) {
            if (this.itemOperationSupplier != null) {
                throw new IllegalArgumentException("can not use the both mapItem and maxItemRx functions");
            }
            if (this.itemMappers == null) {
                this.itemMappers = new ArrayList<RxFunction>();
            }
            this.itemMappers.add(mapper);
            return this;
        }

        @Override
        public Single<T> mapItemRx(RxOperationSupplier<T> supplier) {
            if (this.itemMappers != null) {
                throw new IllegalArgumentException("can not use the both mapItem and maxItemRx functions");
            }
            if (this.itemOperationSupplier != null) {
                throw new IllegalArgumentException("can not use maxItemRx function 2 times");
            }
            this.itemOperationSupplier = supplier;
            return this;
        }

        @Override
        public RxSingle<T> operateItem(RxConsumer<T> consumer) {
            return this.mapItem(it -> {
                consumer.accept(it);
                return null;
            });
        }

        @Override
        public Multiple toMultiple() {
            if (this.itemOperationSupplier != null) {
                return Reactive.multiple(this.returnType).registersRx(this.firstValues, this.itemOperationSupplier);
            }
            return Reactive.multiple(this.returnType).registers(this.firstValues, it -> {
                Object mappedValue = it;
                if (this.itemMappers != null) {
                    for (RxFunction mapper : this.itemMappers) {
                        mappedValue = mapper.apply(mappedValue);
                    }
                }
                return mappedValue;
            });
        }

        @Override
        public void blockingExecute() {
            this.toMultiple().blockingExecute();
        }

        public <R> R blockingGet() {
            return (R)this.toMultiple().blockingGet();
        }
    }

    public static class RxComponent<T extends RxComponent<T>> {
        protected RxReturnType returnType;

        public RxComponent(RxReturnType returnType) {
            this.returnType = returnType;
        }

        public T returnTypeFirst() {
            return this.returnType(RxReturnType.FIST);
        }

        public T returnTypeFirstOrNull() {
            return this.returnType(RxReturnType.FIST_OR_NULL);
        }

        public T returnTypeList() {
            return this.returnType(RxReturnType.LIST);
        }

        public T returnTypeMap() {
            return this.returnType(RxReturnType.MAP);
        }

        public T returnTypeSet() {
            return this.returnType(RxReturnType.SET);
        }

        public T returnType(RxReturnType returnType) {
            this.returnType = returnType;
            return (T)this;
        }
    }
}

