/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.Next;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.DataIndex;
import org.youngmonkeys.ezyplatform.model.SaveDataKeywordModel;
import org.youngmonkeys.ezyplatform.repo.DataIndexRepository;
import org.youngmonkeys.ezyplatform.result.IdResult;
import org.youngmonkeys.ezyplatform.service.DataIndexService;

public class DefaultDataIndexService
extends EzyLoggable
implements DataIndexService {
    private final DataIndexRepository dataIndexRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void saveKeyword(String dataType, SaveDataKeywordModel model) {
        String keyword;
        long dataId = model.getDataId();
        DataIndex entity = this.dataIndexRepository.findByDataTypeAndDataIdAndKeyword(dataType, dataId, keyword = model.getKeyword());
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(dataType, model);
        } else {
            this.modelToEntityConverter.mergeToEntity(model, entity);
        }
        try {
            this.dataIndexRepository.save(entity);
        }
        catch (Exception e) {
            this.logger.info("save keyword: {} of data type: {} and id: {} failed", new Object[]{keyword, dataType, dataId});
        }
    }

    @Override
    public void saveKeywords(String dataType, Collection<SaveDataKeywordModel> dataKeywords) {
        for (SaveDataKeywordModel model : dataKeywords) {
            this.saveKeyword(dataType, model);
        }
    }

    @Override
    public void deleteKeywordsByDataTypeAndDataId(String dataType, long dataId) {
        this.dataIndexRepository.deleteByDataTypeAndDataId(dataType, dataId);
    }

    @Override
    public void deleteKeywordsByDataTypeAndDataIds(String dataType, Collection<Long> dataIds) {
        if (!dataIds.isEmpty()) {
            this.dataIndexRepository.deleteByDataTypeAndDataIdIn(dataType, dataIds);
        }
    }

    @Override
    public boolean containsDataIndex(String dataType, long dataId, String keyword) {
        return this.dataIndexRepository.findByDataTypeAndDataIdAndKeyword(dataType, dataId, keyword) != null;
    }

    @Override
    public List<Long> getDataIdsByTypeAndKeywords(String dataType, Collection<String> keywords, int limit, int maxFetchRound) {
        if (keywords.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> exclusiveDataIds = Collections.singletonList(0L);
        ArrayList<Long> dataIds = new ArrayList<Long>();
        for (int fetchedRound = 0; fetchedRound < maxFetchRound && dataIds.size() < limit; ++fetchedRound) {
            List fetchedDataIds = this.dataIndexRepository.findDataIdsByDataTypeAndKeywordInAndDataIdNotInOrderByPriorityDescIdDesc(dataType, keywords, exclusiveDataIds, Next.limit((long)limit)).stream().map(IdResult::getId).distinct().collect(Collectors.toList());
            dataIds.addAll(fetchedDataIds);
            exclusiveDataIds = dataIds;
            if (fetchedDataIds.size() < limit) break;
        }
        return dataIds.size() <= limit ? dataIds : dataIds.subList(0, limit);
    }

    @Generated
    public DefaultDataIndexService(DataIndexRepository dataIndexRepository, DefaultModelToEntityConverter modelToEntityConverter) {
        this.dataIndexRepository = dataIndexRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

