/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import com.tvd12.ezyfox.io.EzyStrings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;

public final class Numbers {
    private Numbers() {
    }

    public static int roundUpOrDownToInt(double value) {
        int starsInt = (int)value;
        return value - (double)starsInt < 0.5 ? starsInt : starsInt + 1;
    }

    public static String formatToUnitString(Number number, int decimals) {
        long num = number.longValue();
        String format = "%." + decimals + "f";
        if (num >= 1000000000L) {
            if (num % 1000000000L == 0L) {
                return num / 1000000000L + "B";
            }
            return String.format(format, (double)num / 1.0E9) + 'B';
        }
        if (num >= 1000000L) {
            if (num % 1000000L == 0L) {
                return num / 1000000L + "M";
            }
            return String.format(format, (double)num / 1000000.0) + 'M';
        }
        if (num >= 1000L) {
            if (num % 1000L == 0L) {
                return num / 1000L + "K";
            }
            return String.format(format, (double)num / 1000.0) + 'K';
        }
        return String.valueOf(num);
    }

    public static int toIntValue(BigInteger value) {
        return value != null ? value.intValue() : 0;
    }

    public static int toIntOrZero(String value) {
        try {
            return EzyStrings.isBlank((String)value) ? 0 : Integer.parseInt(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long toLongOrZero(String value) {
        try {
            return EzyStrings.isBlank((String)value) ? 0L : Long.parseLong(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static String toPaddedValueLong(BigInteger value) {
        return Numbers.toPaddedValueLong(value, BigInteger.ZERO);
    }

    public static String toPaddedValueLong(BigInteger value, BigInteger defaultValue) {
        return Numbers.toPaddedValue(value, 26, defaultValue);
    }

    public static String toPaddedValueUint256(BigInteger value) {
        return Numbers.toPaddedValueUint256(value, BigInteger.ZERO);
    }

    public static String toPaddedValueUint256(BigInteger value, BigInteger defaultValue) {
        return Numbers.toPaddedValue(value, 76, defaultValue);
    }

    public static String toPaddedValue(BigInteger value, int leadingZeros, BigInteger defaultValue) {
        String format = "%0" + leadingZeros + "d";
        return value == null ? (defaultValue == null ? null : String.format(format, defaultValue)) : String.format(format, value);
    }

    public static BigDecimal stripTrailingZeros(BigDecimal value) {
        return value == null ? null : value.stripTrailingZeros();
    }

    public static String toNoTrailingZerosString(BigDecimal value) {
        return value == null ? null : Numbers.stripTrailingZeros(value).toPlainString();
    }

    public static String toRandomText(long number, int minLength) {
        String suffix = String.valueOf(number);
        if (suffix.length() >= minLength - 1) {
            return "0" + suffix;
        }
        int randomLength = minLength - suffix.length() - 1;
        if (randomLength > 9) {
            randomLength = 9;
        }
        StringBuilder randomNumber = new StringBuilder();
        for (int i = 0; i < randomLength; ++i) {
            randomNumber.append(ThreadLocalRandom.current().nextInt(1, 9));
        }
        int zeroLength = minLength - randomLength - suffix.length() - 1;
        if (zeroLength > 0) {
            for (int i = 0; i < zeroLength; ++i) {
                randomNumber.append("0");
            }
        }
        return String.valueOf(randomLength) + randomNumber + suffix;
    }

    public static long fromRandomText(String randomText) {
        int randomLength = Integer.parseInt(randomText.substring(0, 1));
        if (randomLength == 0) {
            return Long.parseLong(randomText);
        }
        return Long.parseLong(randomText.substring(randomLength + 1));
    }

    public static boolean isFloatingPointText(String input) {
        if (EzyStrings.isBlank((String)input)) {
            return false;
        }
        if (input.indexOf(46) < 0) {
            return false;
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

