/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.concurrent;

import com.tvd12.ezyfox.concurrent.EzyErrorScheduledExecutorService;
import com.tvd12.ezyfox.concurrent.EzyThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public final class EzyExecutors {
    private EzyExecutors() {
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String threadName) {
        return EzyExecutors.newScheduledThreadPool(corePoolSize, EzyExecutors.newThreadFactory(threadName));
    }

    public static ExecutorService newFixedThreadPool(int threadPoolSize, String threadName) {
        return EzyExecutors.newFixedThreadPool(threadPoolSize, EzyExecutors.newThreadFactory(threadName));
    }

    public static ExecutorService newSingleThreadExecutor(String threadName) {
        return EzyExecutors.newSingleThreadExecutor(EzyExecutors.newThreadFactory(threadName));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String threadName) {
        return EzyExecutors.newSingleThreadScheduledExecutor(EzyExecutors.newThreadFactory(threadName));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return Executors.newScheduledThreadPool(corePoolSize, threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int threadPoolSize, ThreadFactory threadFactory) {
        return Executors.newFixedThreadPool(threadPoolSize, threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public static ScheduledExecutorService newErrorScheduledExecutor(String errorMessage) {
        return new EzyErrorScheduledExecutorService(errorMessage);
    }

    public static EzyThreadFactory newThreadFactory(String poolName) {
        return EzyExecutors.newThreadFactory(poolName, false, 5);
    }

    public static EzyThreadFactory newThreadFactory(String poolName, int priority) {
        return EzyExecutors.newThreadFactory(poolName, false, priority);
    }

    public static EzyThreadFactory newThreadFactory(String poolName, boolean daemon) {
        return EzyExecutors.newThreadFactory(poolName, daemon, 5);
    }

    public static EzyThreadFactory newThreadFactory(String poolName, boolean daemon, int priority) {
        return EzyThreadFactory.builder().daemon(daemon).priority(priority).poolName(poolName).build();
    }
}

