/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.stream;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class EzyInputStreams {
    public static final int EOF = -1;
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    private EzyInputStreams() {
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        return EzyInputStreams.toByteArray(stream, 1024);
    }

    public static byte[] toByteArray(InputStream stream, int bufferSize) throws IOException {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            int readBytes;
            byte[] buffer = new byte[bufferSize];
            while ((readBytes = stream.read(buffer)) != -1) {
                outStream.write(buffer, 0, readBytes);
            }
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
    }

    public static String toStringUtf8(InputStream stream) throws IOException {
        return EzyInputStreams.toString(stream, StandardCharsets.UTF_8);
    }

    public static String toString(InputStream stream, Charset charset) throws IOException {
        byte[] bytes = EzyInputStreams.toByteArray(stream);
        return new String(bytes, charset);
    }

    public static List<String> toLines(InputStream stream) throws IOException {
        return EzyInputStreams.toLines(stream, Charset.defaultCharset());
    }

    public static List<String> toLines(InputStream stream, String charset) throws IOException {
        return EzyInputStreams.toLines(stream, Charset.forName(charset));
    }

    public static List<String> toLines(InputStream stream, Charset charset) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, charset));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }
}

