/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.reader;

import com.tvd12.ezyfox.binding.EzyReader;
import com.tvd12.ezyfox.binding.EzyUnmarshaller;
import com.tvd12.ezyfox.io.EzyDates;
import java.time.LocalDate;

public final class EzyLocalDateReader
implements EzyReader<Object, LocalDate> {
    private static final EzyLocalDateReader INSTANCE = new EzyLocalDateReader();

    private EzyLocalDateReader() {
    }

    public static EzyLocalDateReader getInstance() {
        return INSTANCE;
    }

    @Override
    public LocalDate read(EzyUnmarshaller unmarshaller, Object value) {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof Long) {
            return EzyDates.millisToDateTime((long)((Long)value)).toLocalDate();
        }
        if (value instanceof String) {
            return EzyDates.parseDate((String)((String)value), (String)"yyyy-MM-dd");
        }
        throw new IllegalArgumentException("can't convert: " + value + " to LocalDate");
    }
}

