/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.constant.EzyHasIntId;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class EzyEnums {
    private EzyEnums() {
    }

    public static <T extends EzyHasIntId> T valueOf(T[] values, int id) {
        return (T)EzyEnums.valueOf(values, id, EzyHasIntId::getId);
    }

    public static <T> T valueOf(T[] values, Object id, Function<T, Object> idFetcher) {
        for (T v : values) {
            Object vid = idFetcher.apply(v);
            if (!vid.equals(id)) continue;
            return v;
        }
        throw new IllegalArgumentException("has no enum value with id = " + id);
    }

    public static <I, E> Map<I, E> enumMap(Class<E> enumClass, Function<E, I> idFetcher) {
        E[] values = enumClass.getEnumConstants();
        HashMap<I, E> answer = new HashMap<I, E>();
        for (E value : values) {
            I id = idFetcher.apply(value);
            answer.put(id, value);
        }
        return answer;
    }

    public static <E extends EzyConstant> Map<Integer, E> enumMapInt(Class<E> enumClass) {
        return EzyEnums.enumMap(enumClass, EzyHasIntId::getId);
    }
}

