/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import com.tvd12.ezyfox.util.EzyMixedMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class EzyMixedKeyMap<V> {
    protected final Map<Object, Map<Object, V>> maps = new HashMap<Object, Map<Object, V>>();

    public V get(EzyMixedMap.EzyMixedKey key) {
        Map<Object, Object> keys = key.getKeys();
        Set<Object> keyTypeSet = keys.keySet();
        V value = null;
        for (Object keyType : keyTypeSet) {
            Map<Object, V> map = this.maps.get(keyType);
            if (map == null) continue;
            Object keyValue = keys.get(keyType);
            V v = map.get(keyValue);
            if (value == null) {
                value = v;
            }
            if (value == v) continue;
            throw new IllegalArgumentException("too many value mapping to key: " + key);
        }
        return value;
    }

    public V remove(EzyMixedMap.EzyMixedKey key) {
        Object keyValue;
        Map<Object, V> map;
        Map<Object, Object> keys = key.getKeys();
        Set<Object> keyTypeSet = keys.keySet();
        V value = null;
        for (Object keyType : keyTypeSet) {
            map = this.maps.get(keyType);
            if (map == null) continue;
            keyValue = keys.get(keyType);
            V v = map.get(keyValue);
            if (value == null) {
                value = v;
            }
            if (value == v) continue;
            throw new IllegalArgumentException("too many value mapping to key: " + key);
        }
        for (Object keyType : keyTypeSet) {
            map = this.maps.get(keyType);
            if (map == null) continue;
            keyValue = keys.get(keyType);
            map.remove(keyValue);
        }
        return value;
    }

    public V computeIfAbsent(EzyMixedMap.EzyMixedKey key, Supplier<V> valueSupplier) {
        Map<Object, Object> keys = key.getKeys();
        Set<Object> keyTypeSet = keys.keySet();
        Object value = null;
        for (Object keyType : keyTypeSet) {
            Map<Object, V> map = this.maps.get(keyType);
            if (map == null) {
                map = new HashMap<Object, V>();
                this.maps.put(keyType, map);
                continue;
            }
            Object keyValue = keys.get(keyType);
            value = map.get(keyValue);
            if (value == null) continue;
            break;
        }
        if (value == null) {
            value = valueSupplier.get();
        }
        for (Object keyType : keyTypeSet) {
            Object keyValue = keys.get(keyType);
            Map<Object, Object> map = this.maps.get(keyType);
            map.put(keyValue, value);
        }
        return value;
    }
}

