/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.setting;

import com.tvd12.ezyfoxserver.setting.EzyAbstractSocketSettingBuilder;
import com.tvd12.ezyfoxserver.setting.EzySimpleSslConfigSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleWebSocketSetting;

public class EzyWebSocketSettingBuilder
extends EzyAbstractSocketSettingBuilder<EzySimpleWebSocketSetting, EzyWebSocketSettingBuilder> {
    protected int sslPort;
    protected int maxFrameSize;
    protected int writerThreadPoolSize;
    protected int minHandlerThreadPoolSize;
    protected int maxHandlerThreadPoolSize;
    protected EzySimpleSslConfigSetting sslConfig;
    protected boolean managementEnable;

    public EzyWebSocketSettingBuilder() {
        this.port = 2208;
        this.sslPort = 2812;
        this.maxFrameSize = 2048;
        this.writerThreadPoolSize = 8;
        this.minHandlerThreadPoolSize = 4;
        this.maxHandlerThreadPoolSize = 16;
        this.managementEnable = false;
        this.sslConfig = new EzySimpleSslConfigSetting();
        this.codecCreator = "com.tvd12.ezyfox.codec.JacksonCodecCreator";
    }

    public EzyWebSocketSettingBuilder sslPort(int sslPort) {
        this.sslPort = sslPort;
        return this;
    }

    public EzyWebSocketSettingBuilder maxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public EzyWebSocketSettingBuilder writerThreadPoolSize(int writerThreadPoolSize) {
        this.writerThreadPoolSize = writerThreadPoolSize;
        return this;
    }

    public EzyWebSocketSettingBuilder minHandlerThreadPoolSize(int minHandlerThreadPoolSize) {
        this.minHandlerThreadPoolSize = minHandlerThreadPoolSize;
        return this;
    }

    public EzyWebSocketSettingBuilder maxHandlerThreadPoolSize(int maxHandlerThreadPoolSize) {
        this.maxHandlerThreadPoolSize = maxHandlerThreadPoolSize;
        return this;
    }

    public EzyWebSocketSettingBuilder sslConfig(EzySimpleSslConfigSetting sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public EzyWebSocketSettingBuilder managementEnable(boolean managementEnable) {
        this.managementEnable = managementEnable;
        return this;
    }

    @Override
    public EzySimpleWebSocketSetting newSetting() {
        EzySimpleWebSocketSetting p = new EzySimpleWebSocketSetting();
        p.setSslPort(this.sslPort);
        p.setMaxFrameSize(this.maxFrameSize);
        p.setMinHandlerThreadPoolSize(this.minHandlerThreadPoolSize);
        p.setMaxHandlerThreadPoolSize(this.maxHandlerThreadPoolSize);
        p.setWriterThreadPoolSize(this.writerThreadPoolSize);
        p.setSslActive(this.sslActive);
        p.setSslConfig(this.sslConfig);
        p.setManagementEnable(this.managementEnable);
        return p;
    }
}

