/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.ssl;

import com.tvd12.ezyfox.mapping.properties.EzyPropertiesFileReader;
import com.tvd12.ezyfox.mapping.properties.EzySimplePropertiesFileMapper;
import com.tvd12.ezyfoxserver.ssl.EzySimpleSslConfig;
import com.tvd12.ezyfoxserver.ssl.EzySslConfig;
import com.tvd12.ezyfoxserver.ssl.EzySslConfigLoader;
import java.nio.file.Paths;

public class EzySimpleSslConfigLoader
implements EzySslConfigLoader {
    public EzySslConfig load(String filePath) {
        EzySimpleSslConfig answer = this.readConfig(filePath);
        String parent = this.getParentFolder(filePath);
        answer.setKeyStoreFile(this.getPath(parent, answer.getKeyStoreFile()));
        answer.setKeyStorePasswordFile(this.getPath(parent, answer.getKeyStorePasswordFile()));
        answer.setCertificatePasswordFile(this.getPath(parent, answer.getCertificatePasswordFile()));
        return answer;
    }

    protected EzySimpleSslConfig readConfig(String filePath) {
        return (EzySimpleSslConfig)this.newPropertiesReader().read(filePath, EzySimpleSslConfig.class);
    }

    protected EzyPropertiesFileReader newPropertiesReader() {
        return EzySimplePropertiesFileMapper.builder().context(this.getClass()).build();
    }

    protected String getParentFolder(String filePath) {
        return Paths.get(filePath, new String[0]).getParent().toString();
    }

    protected String getPath(String first, String ... more) {
        return Paths.get(first, more).toString();
    }
}

