/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.statistics;

import com.tvd12.ezyfox.io.EzyDates;
import java.io.Serializable;
import lombok.Generated;

public abstract class EzyNetworkBytesFrame
implements Serializable {
    private static final long serialVersionUID = 4153904393261840635L;
    protected final long endTime;
    protected final long startTime;
    protected long readBytes;
    protected long writtenBytes;

    public EzyNetworkBytesFrame() {
        this(System.currentTimeMillis());
    }

    public EzyNetworkBytesFrame(long startTime) {
        this.startTime = startTime;
        this.endTime = startTime + this.getExistsTime();
    }

    protected abstract long getExistsTime();

    public void addReadBytes(long bytes) {
        this.readBytes += bytes;
    }

    public void addWrittenBytes(long bytes) {
        this.writtenBytes += bytes;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.endTime;
    }

    public abstract EzyNetworkBytesFrame nextFrame();

    public String toString() {
        return this.getClass().getSimpleName() + ": " + EzyDates.format((long)this.startTime) + " -> " + EzyDates.format((long)this.endTime);
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getReadBytes() {
        return this.readBytes;
    }

    @Generated
    public long getWrittenBytes() {
        return this.writtenBytes;
    }
}

