/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.wrapper;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.function.EzyFunctions;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.exception.EzyMaxUserException;
import com.tvd12.ezyfoxserver.wrapper.EzyUserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;

public abstract class EzyAbstractUserManager
extends EzyLoggable
implements EzyUserManager {
    protected final int maxUsers;
    protected final Map<String, Lock> locks = this.newLocksMap();
    protected final Map<Long, EzyUser> usersById = this.newUsersByIdMap();
    protected final Map<String, EzyUser> usersByName = this.newUsersByName();

    protected EzyAbstractUserManager(Builder<?> builder) {
        this.maxUsers = builder.maxUsers;
    }

    @Override
    public EzyUser addUser(EzyUser user) {
        EzyUser answer = this.doAddUser(user);
        this.logger.info("{} add user: {}, locks.size = {}, usersById.size = {}, usersByName.size = {}", new Object[]{this.getMessagePrefix(), user, this.locks.size(), this.usersById.size(), this.usersByName.size()});
        return answer;
    }

    protected void checkMaxUsers() {
        int current = this.usersById.size();
        if (current >= this.maxUsers) {
            throw new EzyMaxUserException(current, this.maxUsers);
        }
    }

    protected EzyUser doAddUser(EzyUser user) {
        this.checkMaxUsers();
        this.usersByName.putIfAbsent(user.getName(), user);
        return this.usersById.putIfAbsent(user.getId(), user);
    }

    @Override
    public EzyUser getUser(long userId) {
        return this.usersById.get(userId);
    }

    @Override
    public EzyUser getUser(String username) {
        return this.usersByName.get(username);
    }

    @Override
    public List<EzyUser> getUserList() {
        return new ArrayList<EzyUser>(this.usersById.values());
    }

    @Override
    public boolean containsUser(long userId) {
        return this.usersById.containsKey(userId);
    }

    @Override
    public boolean containsUser(String username) {
        return this.usersByName.containsKey(username);
    }

    @Override
    public EzyUser removeUser(EzyUser user) {
        this.doRemoveUser(user);
        this.logger.info("{} remove user: {}, locks.size = {}, usersById.size = {}, usersByName.size = {}", new Object[]{this.getMessagePrefix(), user, this.locks.size(), this.usersById.size(), this.usersByName.size()});
        return user;
    }

    protected void doRemoveUser(EzyUser user) {
        if (user != null) {
            this.locks.remove(user.getName());
            this.usersById.remove(user.getId());
            this.usersByName.remove(user.getName());
        }
    }

    @Override
    public int getUserCount() {
        return this.usersById.size();
    }

    @Override
    public int getMaxUsers() {
        return this.maxUsers;
    }

    @Override
    public boolean available() {
        return this.usersById.size() < this.maxUsers;
    }

    @Override
    public Lock getLock(String username) {
        return this.locks.computeIfAbsent(username, EzyFunctions.NEW_REENTRANT_LOCK_FUNC);
    }

    @Override
    public void removeLock(String username) {
        this.locks.remove(username);
    }

    @Override
    public void clear() {
        this.locks.clear();
        this.usersById.clear();
        this.usersByName.clear();
    }

    protected String getMessagePrefix() {
        return "user manager:";
    }

    public void destroy() {
        this.clear();
    }

    protected Map<String, Lock> newLocksMap() {
        return new ConcurrentHashMap<String, Lock>();
    }

    protected Map<Long, EzyUser> newUsersByIdMap() {
        return new ConcurrentHashMap<Long, EzyUser>();
    }

    protected Map<String, EzyUser> newUsersByName() {
        return new ConcurrentHashMap<String, EzyUser>();
    }

    public static abstract class Builder<B extends Builder<B>>
    implements EzyBuilder<EzyUserManager> {
        protected int maxUsers = 999999;

        public B maxUsers(int maxUsers) {
            this.maxUsers = maxUsers;
            return (B)this;
        }
    }
}

