/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.support.controller;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.annotation.EzyManagement;
import com.tvd12.ezyfox.annotation.EzyPayment;
import com.tvd12.ezyfox.bean.EzyBeanContext;
import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.binding.EzyUnmarshaller;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.core.annotation.EzyExceptionHandler;
import com.tvd12.ezyfox.core.annotation.EzyRequestController;
import com.tvd12.ezyfox.core.annotation.EzyRequestInterceptor;
import com.tvd12.ezyfox.core.annotation.EzyRequestListener;
import com.tvd12.ezyfox.core.exception.EzyBadRequestException;
import com.tvd12.ezyfox.core.util.EzyRequestInterceptorAnnotations;
import com.tvd12.ezyfox.core.util.EzyRequestListenerAnnotations;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyData;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClassTree;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.context.EzyZoneChildContext;
import com.tvd12.ezyfoxserver.event.EzyUserRequestEvent;
import com.tvd12.ezyfoxserver.event.EzyUserSessionEvent;
import com.tvd12.ezyfoxserver.support.asm.EzyExceptionHandlersImplementer;
import com.tvd12.ezyfoxserver.support.asm.EzyRequestHandlersImplementer;
import com.tvd12.ezyfoxserver.support.controller.EzyAbstractUserRequestController;
import com.tvd12.ezyfoxserver.support.controller.EzyUserRequestPrototypeController;
import com.tvd12.ezyfoxserver.support.exception.EzyUserRequestException;
import com.tvd12.ezyfoxserver.support.factory.EzyResponseFactory;
import com.tvd12.ezyfoxserver.support.handler.EzyUncaughtExceptionHandler;
import com.tvd12.ezyfoxserver.support.handler.EzyUserRequestHandler;
import com.tvd12.ezyfoxserver.support.handler.EzyUserRequestHandlerProxy;
import com.tvd12.ezyfoxserver.support.handler.EzyUserRequestInterceptor;
import com.tvd12.ezyfoxserver.support.manager.EzyFeatureCommandManager;
import com.tvd12.ezyfoxserver.support.manager.EzyRequestCommandManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class EzyUserRequestSingletonController<C extends EzyZoneChildContext, E extends EzyUserRequestEvent>
extends EzyAbstractUserRequestController {
    protected final EzyUnmarshaller unmarshaller;
    protected final EzyResponseFactory responseFactory;
    protected final List<Class<?>> handledExceptionClasses;
    protected final Map<String, EzyUserRequestHandler> requestHandlers;
    protected final List<EzyUserRequestInterceptor> requestInterceptors;
    protected final Map<Class<?>, EzyUncaughtExceptionHandler> exceptionHandlers;
    protected final EzyUserRequestPrototypeController prototypeController;

    protected EzyUserRequestSingletonController(Builder<?> builder) {
        this.unmarshaller = builder.unmarshaller;
        this.responseFactory = builder.responseFactory;
        this.prototypeController = builder.getPrototypeController();
        this.requestHandlers = new HashMap<String, EzyUserRequestHandler>(((Builder)builder).extractRequestHandlers());
        this.exceptionHandlers = new HashMap(((Builder)builder).getExceptionHandlers());
        this.requestInterceptors = new ArrayList<EzyUserRequestInterceptor>(((Builder)builder).getRequestInterceptors());
        this.handledExceptionClasses = new EzyClassTree(this.exceptionHandlers.keySet()).toList();
    }

    public void handle(C context, E event) {
        EzyArray data = event.getData();
        String cmd = (String)data.get(0, String.class);
        EzyUserRequestHandler handler = this.requestHandlers.get(cmd);
        if (handler == null) {
            this.prototypeController.handle(context, event);
            return;
        }
        Object handlerData = data.get(1, EzyData.class, null);
        Class requestDataType = handler.getDataType();
        if (requestDataType != null) {
            handlerData = this.unmarshaller.unmarshal(handlerData, requestDataType);
        }
        try {
            this.preHandle(context, event, cmd, handlerData);
            handler.handle(context, (EzyUserSessionEvent)event, handlerData);
            this.postHandle(context, event, cmd, handlerData);
        }
        catch (Exception e) {
            this.postHandle(context, event, cmd, handlerData, e);
            if (e instanceof EzyBadRequestException) {
                EzyBadRequestException ex = (EzyBadRequestException)e;
                if (ex.isSendToClient()) {
                    EzyData errorData = this.newErrorData(ex);
                    this.responseError(context, event, errorData);
                }
                this.logger.debug("request cmd: {} by session: {} with data: {} error", new Object[]{cmd, event.getSession().getName(), data, e});
            }
            EzyUncaughtExceptionHandler exceptionHandler = this.getExceptionHandler(e.getClass());
            if (exceptionHandler == null) {
                throw new EzyUserRequestException(cmd, handlerData, e);
            }
            try {
                exceptionHandler.handleException(context, (EzyUserSessionEvent)event, cmd, handlerData, e);
            }
            catch (Exception ex) {
                throw new EzyUserRequestException(cmd, handlerData, ex);
            }
        }
    }

    protected void preHandle(C context, E event, String cmd, Object data) {
        for (EzyUserRequestInterceptor interceptor : this.requestInterceptors) {
            interceptor.preHandle(context, (EzyUserSessionEvent)event, cmd, data);
        }
    }

    protected void postHandle(C context, E event, String cmd, Object data) {
        for (EzyUserRequestInterceptor interceptor : this.requestInterceptors) {
            interceptor.postHandle(context, (EzyUserSessionEvent)event, cmd, data);
        }
    }

    protected void postHandle(C context, E event, String cmd, Object data, Exception e) {
        for (EzyUserRequestInterceptor interceptor : this.requestInterceptors) {
            interceptor.postHandle(context, (EzyUserSessionEvent)event, cmd, data, e);
        }
    }

    protected EzyUncaughtExceptionHandler getExceptionHandler(Class<?> exceptionClass) {
        for (Class<?> exc : this.handledExceptionClasses) {
            if (!exc.isAssignableFrom(exceptionClass)) continue;
            return this.exceptionHandlers.get(exc);
        }
        return null;
    }

    protected abstract void responseError(C var1, E var2, EzyData var3);

    @Override
    public Set<String> getCommands() {
        HashSet<String> commands = new HashSet<String>();
        commands.addAll(this.requestHandlers.keySet());
        commands.addAll(this.prototypeController.getCommands());
        return commands;
    }

    public static abstract class Builder<B extends Builder>
    extends EzyLoggable
    implements EzyBuilder<EzyUserRequestSingletonController> {
        protected EzyBeanContext beanContext;
        protected EzyUnmarshaller unmarshaller;
        protected EzyResponseFactory responseFactory;
        protected EzySingletonFactory singletonFactory;
        protected EzyFeatureCommandManager featureCommandManager;
        protected EzyRequestCommandManager requestCommandManager;

        public B beanContext(EzyBeanContext beanContext) {
            this.beanContext = beanContext;
            this.singletonFactory = beanContext.getSingletonFactory();
            this.responseFactory = (EzyResponseFactory)beanContext.getSingleton(EzyResponseFactory.class);
            this.unmarshaller = (EzyUnmarshaller)beanContext.getSingleton("unmarshaller", EzyUnmarshaller.class);
            this.featureCommandManager = (EzyFeatureCommandManager)beanContext.getSingleton(EzyFeatureCommandManager.class);
            this.requestCommandManager = (EzyRequestCommandManager)beanContext.getSingleton(EzyRequestCommandManager.class);
            return (B)((Object)this);
        }

        protected abstract EzyUserRequestPrototypeController getPrototypeController();

        private Map<String, EzyUserRequestHandler> extractRequestHandlers() {
            Map<String, EzyUserRequestHandlerProxy> fromListeners = this.extractRequestHandlersFromListener();
            this.extractRequestCommands(fromListeners);
            HashMap<String, EzyUserRequestHandler> handlers = new HashMap<String, EzyUserRequestHandler>(fromListeners);
            handlers.putAll(this.implementClientRequestHandlers());
            return handlers;
        }

        private Map<String, EzyUserRequestHandlerProxy> extractRequestHandlersFromListener() {
            List<Object> clientRequestHandlers = this.getClientRequestHandlers();
            HashMap<String, EzyUserRequestHandlerProxy> handlers = new HashMap<String, EzyUserRequestHandlerProxy>();
            for (Object handler : clientRequestHandlers) {
                Class<?> handleType = handler.getClass();
                EzyRequestListener annotation = handleType.getAnnotation(EzyRequestListener.class);
                String command = EzyRequestListenerAnnotations.getCommand((EzyRequestListener)annotation);
                handlers.put(command, new EzyUserRequestHandlerProxy((EzyUserRequestHandler)handler));
                this.logger.debug("add command {} and request handler {}", (Object)command, handler);
            }
            return handlers;
        }

        private void extractRequestCommands(Map<String, EzyUserRequestHandlerProxy> handlers) {
            for (String command : handlers.keySet()) {
                EzyFeature featureAnno;
                EzyUserRequestHandlerProxy handler = handlers.get(command);
                Class<?> handleType = handler.getHandler().getClass();
                this.requestCommandManager.addCommand(command);
                if (handleType.isAnnotationPresent(EzyManagement.class)) {
                    this.requestCommandManager.addManagementCommand(command);
                }
                if (handleType.isAnnotationPresent(EzyPayment.class)) {
                    this.requestCommandManager.addPaymentCommand(command);
                }
                if ((featureAnno = handleType.getAnnotation(EzyFeature.class)) == null || !EzyStrings.isNotBlank((String)featureAnno.value())) continue;
                this.featureCommandManager.addFeatureCommand(featureAnno.value(), command);
            }
        }

        private List<EzyUserRequestInterceptor> getRequestInterceptors() {
            List interceptors = this.singletonFactory.getSingletons(new Class[]{EzyRequestInterceptor.class});
            ArrayList<EzyUserRequestInterceptor> answer = new ArrayList<EzyUserRequestInterceptor>();
            for (EzyUserRequestInterceptor interceptor : interceptors) {
                this.logger.debug("add interceptor {}", (Object)interceptor);
                answer.add(interceptor);
            }
            answer.sort(Comparator.comparingInt(a -> EzyRequestInterceptorAnnotations.getPriority(a.getClass())));
            return interceptors;
        }

        private Map<Class<?>, EzyUncaughtExceptionHandler> getExceptionHandlers() {
            HashMap handlers = new HashMap();
            Map<Class<?>, EzyUncaughtExceptionHandler> implementedHandlers = this.implementExceptionHandlers();
            for (Class<?> exceptionClass : implementedHandlers.keySet()) {
                EzyUncaughtExceptionHandler handler = implementedHandlers.get(exceptionClass);
                this.logger.debug("add exception {} and handler {}", (Object)exceptionClass.getName(), (Object)handler);
                handlers.put(exceptionClass, handler);
            }
            return handlers;
        }

        private List<Object> getClientRequestHandlers() {
            return this.singletonFactory.getSingletons(new Class[]{EzyRequestListener.class});
        }

        private Map<String, EzyUserRequestHandler> implementClientRequestHandlers() {
            EzyRequestHandlersImplementer implementer = new EzyRequestHandlersImplementer();
            implementer.setResponseFactory(this.responseFactory);
            implementer.setFeatureCommandManager(this.featureCommandManager);
            implementer.setRequestCommandManager(this.requestCommandManager);
            implementer.setAllowOverrideCommand((Boolean)this.beanContext.getProperty((Object)"module.allow_override_uri", Boolean.TYPE, (Object)false));
            Map<String, EzyUserRequestHandler> implementedHandlers = implementer.implement(this.singletonFactory.getSingletons(new Class[]{EzyRequestController.class}));
            for (String command : implementedHandlers.keySet()) {
                EzyUserRequestHandler handler = implementedHandlers.get(command);
                this.logger.debug("add command {} and request handler {}", (Object)command, (Object)handler);
            }
            return implementedHandlers;
        }

        private Map<Class<?>, EzyUncaughtExceptionHandler> implementExceptionHandlers() {
            EzyExceptionHandlersImplementer implementer = new EzyExceptionHandlersImplementer();
            return implementer.implement(this.singletonFactory.getSingletons(new Class[]{EzyExceptionHandler.class}));
        }
    }
}

