/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.view;

import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.server.core.view.View;
import com.tvd12.ezyhttp.server.core.view.ViewDecorator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.service.WebLanguageService;
import org.youngmonkeys.ezyplatform.util.HttpRequests;

public class WebViewLanguageDecorator
implements ViewDecorator {
    @EzyAutoBind
    private WebLanguageService webLanguageService;

    public void decorate(HttpServletRequest request, View view) {
        this.setLanguage(request, view);
        this.setLanguages(request, view);
    }

    protected void setLanguage(HttpServletRequest request, View view) {
        String lang = HttpRequests.getLanguage((HttpServletRequest)request);
        if (EzyStrings.isBlank((String)lang)) {
            if (view.containsVariable("ezyDefaultLang")) {
                return;
            }
            lang = this.webLanguageService.getDefaultLanguageCode();
            if (EzyStrings.isNotBlank((String)lang)) {
                request.setAttribute("lang", (Object)lang);
                view.setLocale(new Locale(lang));
                view.setVariable("ezyDefaultLang", (Object)lang);
            }
        } else {
            if (view.containsVariable("ezyLang")) {
                return;
            }
            view.setLocale(new Locale(lang));
            view.setVariable("ezyLang", (Object)lang);
        }
    }

    protected void setLanguages(HttpServletRequest request, View view) {
        if (!view.containsVariable("webLanguages") && this.includeWebLanguages()) {
            view.setVariable("webLanguages", (Object)this.webLanguageService.getActiveLanguages());
        }
    }

    protected boolean includeWebLanguages() {
        return false;
    }

    @Generated
    public void setWebLanguageService(WebLanguageService webLanguageService) {
        this.webLanguageService = webLanguageService;
    }
}

