/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import com.tvd12.ezyfox.io.EzyStrings;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.constant.ExtendedDay;
import org.youngmonkeys.ezyplatform.constant.ExtendedMonth;
import org.youngmonkeys.ezyplatform.constant.ExtendedWeek;
import org.youngmonkeys.ezyplatform.constant.ExtendedYear;
import org.youngmonkeys.ezyplatform.time.ClockProxy;

public class LocalDateTimeRangeModel {
    private LocalDateTime start;
    private LocalDateTime end;
    public static final LocalDateTimeRangeModel DEFAULT = new LocalDateTimeRangeModel();

    public static LocalDateTimeRangeModel parseYears(String value) {
        if (EzyStrings.isBlank((String)value)) {
            return DEFAULT;
        }
        LocalDate start = null;
        LocalDate end = null;
        if (value.contains("|") || value.contains(" - ")) {
            int year2;
            String[] strs = value.contains("|") ? value.split("\\|") : value.split(" - ");
            try {
                year2 = Integer.parseInt(strs[0]);
                start = LocalDate.of(year2, 1, 1);
            }
            catch (Exception year2) {
                // empty catch block
            }
            try {
                year2 = Integer.parseInt(strs[1]);
                end = LocalDate.of(year2, 1, 1);
            }
            catch (Exception exception) {}
        } else {
            try {
                int year = Integer.parseInt(value);
                start = LocalDate.of(year, 1, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LocalDateTimeRangeModel(start != null ? start.atStartOfDay() : null, end != null ? end.atStartOfDay() : null);
    }

    public static LocalDateTimeRangeModel parseMonths(String value) {
        if (EzyStrings.isBlank((String)value)) {
            return DEFAULT;
        }
        LocalDate start = null;
        LocalDate end = null;
        if (value.contains("|") || value.contains(" - ")) {
            String[] strs = value.contains("|") ? value.split("\\|") : value.split(" - ");
            try {
                start = LocalDate.parse(strs[0] + "-01");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                end = LocalDate.parse(strs[1] + "-01");
            }
            catch (Exception exception) {}
        } else {
            try {
                start = LocalDate.parse(value + "-01");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LocalDateTimeRangeModel(start != null ? start.atStartOfDay() : null, end != null ? end.atStartOfDay() : null);
    }

    public static LocalDateTimeRangeModel parseDays(String value) {
        if (EzyStrings.isBlank((String)value)) {
            return DEFAULT;
        }
        LocalDate start = null;
        LocalDate end = null;
        if (value.contains("|") || value.contains(" - ")) {
            String[] strs = value.contains("|") ? value.split("\\|") : value.split(" - ");
            try {
                start = LocalDate.parse(strs[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                end = LocalDate.parse(strs[1]);
            }
            catch (Exception exception) {}
        } else {
            try {
                start = LocalDate.parse(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LocalDateTimeRangeModel(start != null ? start.atStartOfDay() : null, end != null ? end.atStartOfDay() : null);
    }

    public static LocalDateTimeRangeModel parseDateTimes(String value) {
        if (EzyStrings.isBlank((String)value)) {
            return DEFAULT;
        }
        LocalDateTime start = null;
        LocalDateTime end = null;
        if (value.contains("|") || value.contains(" - ")) {
            String[] strs = value.contains("|") ? value.split("\\|") : value.split(" - ");
            try {
                start = LocalDateTime.parse(strs[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                end = LocalDateTime.parse(strs[1]);
            }
            catch (Exception exception) {}
        } else {
            try {
                start = LocalDateTime.parse(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LocalDateTimeRangeModel(start, end);
    }

    public static LocalDateTimeRangeModel parseDayOfWeek(String value) {
        return LocalDateTimeRangeModel.parseDayOfWeek(LocalDateTime.now(), value);
    }

    public static LocalDateTimeRangeModel parseDayOfWeek(LocalDateTime now, String value) {
        DayOfWeek dayOfWeek;
        if (EzyStrings.isBlank((String)value)) {
            return DEFAULT;
        }
        try {
            dayOfWeek = DayOfWeek.valueOf(value);
        }
        catch (Exception e) {
            return DEFAULT;
        }
        LocalDate start = now.toLocalDate().with(dayOfWeek.compareTo(now.getDayOfWeek()) < 0 ? TemporalAdjusters.previousOrSame(dayOfWeek) : TemporalAdjusters.nextOrSame(dayOfWeek));
        LocalDate end = start.plusDays(1L);
        return new LocalDateTimeRangeModel(start.atStartOfDay(), end.atStartOfDay());
    }

    public static LocalDateTimeRangeModel parseExtendedDay(String value) {
        return LocalDateTimeRangeModel.parseExtendedDay(LocalDateTime.now(), value);
    }

    public static LocalDateTimeRangeModel parseExtendedDay(LocalDateTime now, String value) {
        if (EzyStrings.isBlank((String)value)) {
            return DEFAULT;
        }
        LocalDate start = null;
        LocalDate end = null;
        ExtendedDay extendedDay = ExtendedDay.of(value);
        if (extendedDay == ExtendedDay.TODAY) {
            start = now.toLocalDate();
            end = start.plusDays(1L);
        } else if (extendedDay == ExtendedDay.YESTERDAY) {
            end = now.toLocalDate();
            start = end.minusDays(1L);
        }
        return new LocalDateTimeRangeModel(start != null ? start.atStartOfDay() : null, end != null ? end.atStartOfDay() : null);
    }

    public static LocalDateTimeRangeModel parseExtendedWeek(String value) {
        return LocalDateTimeRangeModel.parseExtendedWeek(LocalDateTime.now(), value);
    }

    public static LocalDateTimeRangeModel parseExtendedWeek(LocalDateTime now, String value) {
        if (EzyStrings.isBlank((String)value)) {
            return DEFAULT;
        }
        LocalDate start = null;
        LocalDate end = null;
        ExtendedWeek extendedWeek = ExtendedWeek.of(value);
        if (extendedWeek == ExtendedWeek.THIS_WEEK) {
            start = now.toLocalDate().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
            end = start.plusDays(7L);
        } else if (extendedWeek == ExtendedWeek.LAST_WEEK) {
            end = now.toLocalDate().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
            start = end.minusDays(7L);
        }
        return new LocalDateTimeRangeModel(start != null ? start.atStartOfDay() : null, end != null ? end.atStartOfDay() : null);
    }

    public static LocalDateTimeRangeModel parseExtendedMonth(String value) {
        return LocalDateTimeRangeModel.parseExtendedMonth(LocalDateTime.now(), value);
    }

    public static LocalDateTimeRangeModel parseExtendedMonth(LocalDateTime now, String value) {
        if (EzyStrings.isBlank((String)value)) {
            return DEFAULT;
        }
        LocalDate start = null;
        LocalDate end = null;
        ExtendedMonth extendedMonth = ExtendedMonth.of(value);
        if (extendedMonth == ExtendedMonth.THIS_MONTH) {
            start = LocalDate.of(now.getYear(), now.getMonth(), 1);
            end = start.plusMonths(1L);
        } else if (extendedMonth == ExtendedMonth.LAST_MONTH) {
            end = LocalDate.of(now.getYear(), now.getMonth(), 1);
            start = end.minusMonths(1L);
        } else if (extendedMonth != null) {
            Month month = extendedMonth.toMonth();
            start = LocalDate.of(now.getYear(), month, 1);
            end = start.plusMonths(1L);
        }
        return new LocalDateTimeRangeModel(start != null ? start.atStartOfDay() : null, end != null ? end.atStartOfDay() : null);
    }

    public static LocalDateTimeRangeModel parseExtendedYear(String value) {
        return LocalDateTimeRangeModel.parseExtendedYear(LocalDateTime.now(), value);
    }

    public static LocalDateTimeRangeModel parseExtendedYear(LocalDateTime now, String value) {
        if (EzyStrings.isBlank((String)value)) {
            return DEFAULT;
        }
        LocalDate start = null;
        LocalDate end = null;
        ExtendedYear extendedYear = ExtendedYear.of(value);
        if (extendedYear == ExtendedYear.THIS_YEAR) {
            start = LocalDate.of(now.getYear(), 1, 1);
            end = start.plusYears(1L);
        } else if (extendedYear == ExtendedYear.LAST_YEAR) {
            end = LocalDate.of(now.getYear(), 1, 1);
            start = end.minusYears(1L);
        }
        return new LocalDateTimeRangeModel(start != null ? start.atStartOfDay() : null, end != null ? end.atStartOfDay() : null);
    }

    public static LocalDateTimeRangeModel parseTimestamps(ClockProxy clock, Long timestampStart, Long timestampEnd) {
        LocalDateTime start = null;
        LocalDateTime end = null;
        if (timestampStart != null && timestampStart >= 0L) {
            start = clock.toLocalDateTime(timestampStart);
        }
        if (timestampEnd != null && timestampEnd >= 0L) {
            end = clock.toLocalDateTime(timestampEnd);
        }
        return new LocalDateTimeRangeModel(start, end);
    }

    public boolean isEmpty() {
        return this.start == null && this.end == null;
    }

    @Generated
    public LocalDateTime getStart() {
        return this.start;
    }

    @Generated
    public LocalDateTime getEnd() {
        return this.end;
    }

    @Generated
    public LocalDateTimeRangeModel(LocalDateTime start, LocalDateTime end) {
        this.start = start;
        this.end = end;
    }

    @Generated
    public LocalDateTimeRangeModel() {
    }
}

