/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import org.youngmonkeys.ezyplatform.pagination.SortOrder;

public final class PaginationParameters {
    private PaginationParameters() {
    }

    public static String makeOrderByAsc(boolean nextPage, String ... fieldNames) {
        return PaginationParameters.makeOrderBy(SortOrder.ASC, nextPage, fieldNames);
    }

    public static String makeOrderByDesc(boolean nextPage, String ... fieldNames) {
        return PaginationParameters.makeOrderBy(SortOrder.DESC, nextPage, fieldNames);
    }

    public static String makeOrderBy(SortOrder sortOrder, boolean nextPage, String ... fieldNames) {
        return PaginationParameters.makeOrderBy("e", sortOrder, nextPage, fieldNames);
    }

    public static String makeOrderBy(String entityName, SortOrder sortOrder, boolean nextPage, String ... fieldNames) {
        return PaginationParameters.makeOrderBy(sortOrder, nextPage, new String[]{entityName}, fieldNames);
    }

    public static String makeOrderBy(SortOrder sortOrder, boolean nextPage, String[] entityNames, String[] fieldNames) {
        SortOrder actualSortOrder = nextPage ? sortOrder : sortOrder.getReverse();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < fieldNames.length; ++i) {
            String entityName = entityNames.length > i ? entityNames[i] : entityNames[0];
            builder.append(entityName).append('.').append(fieldNames[i]).append(' ').append((Object)actualSortOrder);
            if (i >= fieldNames.length - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static String makePaginationConditionAsc(boolean nextPage, String ... fieldNames) {
        return PaginationParameters.makePaginationCondition(SortOrder.ASC, nextPage, fieldNames);
    }

    public static String makePaginationConditionDesc(boolean nextPage, String ... fieldNames) {
        return PaginationParameters.makePaginationCondition(SortOrder.DESC, nextPage, fieldNames);
    }

    public static String makePaginationCondition(SortOrder sortOrder, boolean nextPage, String ... fieldNames) {
        return PaginationParameters.makePaginationCondition("e", sortOrder, nextPage, fieldNames);
    }

    public static String makePaginationCondition(String entityName, SortOrder sortOrder, boolean nextPage, String ... fieldNames) {
        return PaginationParameters.makePaginationCondition(sortOrder, nextPage, new String[]{entityName}, fieldNames, fieldNames);
    }

    public static String makePaginationCondition(SortOrder sortOrder, boolean nextPage, String[] entityNames, String[] fieldNames) {
        return PaginationParameters.makePaginationCondition(sortOrder, nextPage, entityNames, fieldNames, fieldNames);
    }

    public static String makePaginationCondition(SortOrder sortOrder, boolean nextPage, String[] entityNames, String[] fieldNames, String[] parameterNames) {
        int i;
        SortOrder actualSortOrder = nextPage ? sortOrder : sortOrder.getReverse();
        int fieldCount = fieldNames.length;
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < fieldCount; ++i) {
            String entityName = entityNames.length > i ? entityNames[i] : entityNames[0];
            builder.append(entityName).append('.').append(fieldNames[i]).append(' ').append(actualSortOrder.getSign()).append(" :").append(parameterNames[i]);
            if (fieldCount <= 1 || i >= fieldCount - 1) continue;
            builder.append(" OR (");
            for (int k = 0; k <= i; ++k) {
                entityName = entityNames.length > i ? entityNames[k] : entityNames[0];
                builder.append(entityName).append('.').append(fieldNames[k]).append(" = :").append(parameterNames[k]).append(" AND ");
            }
        }
        for (i = 1; i < fieldNames.length; ++i) {
            builder.append(')');
        }
        return builder.toString();
    }
}

