/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.repo;

import com.tvd12.ezydata.database.query.EzyQueryData;
import com.tvd12.ezydata.database.query.EzyQueryMethodType;
import com.tvd12.ezydata.jpa.repository.EzyJpaRepository;
import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyGenerics;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.youngmonkeys.ezyplatform.data.PaginationParameter;
import org.youngmonkeys.ezyplatform.data.StorageFilter;
import org.youngmonkeys.ezyplatform.entity.Setting;
import org.youngmonkeys.ezyplatform.pagination.CommonPaginationParameter;
import org.youngmonkeys.ezyplatform.pagination.CommonStorageFilter;
import org.youngmonkeys.ezyplatform.pagination.OffsetPaginationParameter;

public class PaginationResultRepository<F, P, I, E, R>
extends EzyJpaRepository<I, E> {
    protected final Class<R> resultType = this.getResultType();

    public List<R> findFirstElements(F filter, int limit) {
        return this.findNextElements(filter, null, limit);
    }

    public List<R> findFirstElements(F filter, int offset, int limit) {
        return this.findNextElements(filter, null, offset, limit);
    }

    public List<R> findNextElements(F filter, P paginationParameter, int limit) {
        return this.findElements(filter, paginationParameter, limit, true);
    }

    public List<R> findNextElements(F filter, P paginationParameter, int offset, int limit) {
        return this.findElements(filter, paginationParameter, offset, limit, true);
    }

    public List<R> findLastElements(F filter, int limit) {
        return this.findPreviousElements(filter, null, limit);
    }

    public List<R> findPreviousElements(F filter, P paginationParameter, int limit) {
        return this.findElements(filter, paginationParameter, limit, false);
    }

    public long countElements(F filter) {
        EzyQueryData queryData = this.makeQuery(EzyQueryMethodType.COUNT, filter, null, true);
        return this.countByQueryString(queryData.getQuery(), queryData.getParameterMap());
    }

    private List<R> findElements(F filter, P paginationParameter, int limit, boolean nextPage) {
        int actualOffset = 0;
        int actualLimit = limit;
        if (paginationParameter instanceof OffsetPaginationParameter) {
            int offset = ((OffsetPaginationParameter)paginationParameter).getOffset();
            actualLimit = offset >= 0 ? limit : limit + offset;
            actualLimit = Math.max(actualLimit, 0);
            actualOffset = Math.max(offset, 0);
        }
        return this.findElements(filter, paginationParameter, actualOffset, actualLimit, nextPage);
    }

    private List<R> findElements(F filter, P paginationParameter, int offset, int limit, boolean nextPage) {
        EzyQueryData query = this.makeQuery(EzyQueryMethodType.FIND, filter, paginationParameter, nextPage);
        return this.resultType != this.entityType ? this.fetchListByQueryString(query.getQuery(), query.getParameterMap(), this.resultType, offset, limit) : this.findListByQueryString(query.getQuery(), query.getParameterMap(), offset, limit);
    }

    private EzyQueryData makeQuery(EzyQueryMethodType methodType, F filter, P paginationParameter, boolean nextPage) {
        StringBuilder queryString = new StringBuilder().append("SELECT");
        boolean distinct = this.isDistinct();
        if (methodType == EzyQueryMethodType.COUNT) {
            queryString.append(" COUNT(");
            if (distinct) {
                queryString.append(" DISTINCT ");
            }
            queryString.append(this.getCountField(filter)).append(")");
        } else {
            List<String> selectionFields;
            if (distinct) {
                queryString.append(" DISTINCT");
            }
            if (EzyCollections.isEmpty(selectionFields = this.getSelectionFields(filter, paginationParameter))) {
                queryString.append(" e");
            } else {
                queryString.append(" ").append(String.join((CharSequence)",", selectionFields));
            }
        }
        queryString.append(" FROM ").append(this.getFromName()).append(" e");
        this.decorateQueryStringBeforeWhere(queryString, filter, paginationParameter);
        String matchingCondition = this.makeMatchingCondition(filter);
        String paginationCondition = methodType == EzyQueryMethodType.COUNT || paginationParameter == null ? "" : this.makePaginationCondition(paginationParameter, nextPage);
        boolean matchingConditionNotBlank = EzyStrings.isNotBlank((String)matchingCondition);
        boolean paginationConditionNotBlank = EzyStrings.isNotBlank((String)paginationCondition);
        if (matchingConditionNotBlank || paginationConditionNotBlank) {
            queryString.append(" WHERE ");
            if (matchingConditionNotBlank) {
                queryString.append(matchingCondition);
            }
            if (matchingConditionNotBlank && paginationConditionNotBlank) {
                queryString.append(" AND ");
            }
            if (paginationConditionNotBlank) {
                queryString.append("(").append(paginationCondition).append(")");
            }
        }
        if (methodType == EzyQueryMethodType.FIND) {
            String orderBy;
            String groupBy = this.makeGroupBy(filter, paginationParameter);
            if (EzyStrings.isNotBlank((String)groupBy)) {
                queryString.append(" GROUP BY ").append(groupBy);
            }
            if (EzyStrings.isNotBlank((String)(orderBy = this.makeOrderBy(filter, paginationParameter, nextPage)))) {
                queryString.append(" ORDER BY ").append(orderBy);
            }
        }
        return EzyQueryData.builder().parameters(this.getQueryParameters(methodType, filter, paginationParameter)).query(queryString.toString()).build();
    }

    protected String getFromName() {
        return this.entityType.getSimpleName();
    }

    protected String getCountField(F filter) {
        if (filter instanceof CommonStorageFilter) {
            return ((CommonStorageFilter)filter).countField();
        }
        return this.getCountField();
    }

    protected String getCountField() {
        return "e";
    }

    protected List<String> getSelectionFields(F filter, P paginationParameter) {
        return Stream.of(this.getSelectionFields(filter), this.getPaginationSelectionFields(paginationParameter), this.getSelectionFields()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected List<String> getSelectionFields(F filter) {
        if (filter instanceof CommonStorageFilter) {
            return ((CommonStorageFilter)filter).selectionFields();
        }
        return Collections.emptyList();
    }

    protected List<String> getSelectionFields() {
        return Collections.emptyList();
    }

    protected List<String> getPaginationSelectionFields(P paginationParameter) {
        if (paginationParameter instanceof CommonPaginationParameter) {
            return ((CommonPaginationParameter)paginationParameter).selectionFields();
        }
        return Collections.emptyList();
    }

    protected boolean isDistinct() {
        return false;
    }

    protected void decorateQueryStringBeforeWhere(StringBuilder queryString, F filter, P paginationParameter) {
        this.decorateQueryStringBeforeWhere(queryString, filter);
        this.decoratePaginationQueryStringBeforeWhere(queryString, paginationParameter);
        this.decorateQueryStringBeforeWhere(queryString);
    }

    protected void decorateQueryStringBeforeWhere(StringBuilder queryString, F filter) {
        if (filter instanceof CommonStorageFilter) {
            ((CommonStorageFilter)filter).decorateQueryStringBeforeWhere(queryString);
        }
    }

    protected void decorateQueryStringBeforeWhere(StringBuilder queryString) {
    }

    protected void decoratePaginationQueryStringBeforeWhere(StringBuilder queryString, P paginationParameter) {
        if (paginationParameter instanceof CommonPaginationParameter) {
            ((CommonPaginationParameter)paginationParameter).decorateQueryStringBeforeWhere(queryString);
        }
    }

    protected String makeMatchingCondition(F filter) {
        if (filter instanceof CommonStorageFilter) {
            return ((CommonStorageFilter)filter).matchingCondition();
        }
        return this.makeMatchingCondition();
    }

    protected String makeMatchingCondition() {
        return "";
    }

    protected String makePaginationCondition(P paginationParameter, boolean nextPage) {
        if (paginationParameter instanceof CommonPaginationParameter) {
            return ((CommonPaginationParameter)paginationParameter).paginationCondition(nextPage);
        }
        return this.makePaginationCondition(nextPage);
    }

    protected String makePaginationCondition(boolean nextPage) {
        return "";
    }

    protected String makeGroupBy(F filter, P paginationParameter) {
        return Stream.of(this.makeGroupBy(filter), this.makePaginationGroupBy(paginationParameter), this.makeGroupBy()).filter(EzyStrings::isNotBlank).collect(Collectors.joining());
    }

    protected String makeGroupBy(F filter) {
        if (filter instanceof CommonStorageFilter) {
            return ((CommonStorageFilter)filter).groupBy();
        }
        return "";
    }

    protected String makeGroupBy() {
        return "";
    }

    protected String makePaginationGroupBy(P paginationParameter) {
        if (paginationParameter instanceof CommonPaginationParameter) {
            return ((CommonPaginationParameter)paginationParameter).groupBy();
        }
        return "";
    }

    protected String makeOrderBy(F filter, P paginationParameter, boolean nextPage) {
        return Stream.of(this.makeOrderBy(filter), this.makeOrderBy(paginationParameter, nextPage)).filter(EzyStrings::isNotBlank).collect(Collectors.joining(", "));
    }

    protected String makeOrderBy(F filter) {
        if (filter instanceof CommonStorageFilter) {
            return ((CommonStorageFilter)filter).orderBy();
        }
        return "";
    }

    protected String makeOrderBy(P paginationParameter, boolean nextPage) {
        if (paginationParameter instanceof CommonPaginationParameter) {
            return ((CommonPaginationParameter)paginationParameter).orderBy(nextPage);
        }
        if (paginationParameter instanceof OffsetPaginationParameter) {
            return ((OffsetPaginationParameter)paginationParameter).getOrderBy();
        }
        return this.makeOrderBy(nextPage);
    }

    protected String makeOrderBy(boolean nextPage) {
        return "";
    }

    private Map<String, Object> getQueryParameters(EzyQueryMethodType methodType, F filter, P paginationParameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(this.getFilterQueryParameters(filter));
        if (methodType != EzyQueryMethodType.COUNT) {
            parameters.putAll(this.getPaginationQueryParameters(paginationParameter));
        }
        return parameters;
    }

    protected Map<String, Object> getFilterQueryParameters(F filter) {
        if (filter instanceof StorageFilter) {
            return ((StorageFilter)filter).getParameters();
        }
        return filter == null ? Collections.emptyMap() : Collections.singletonMap("filter", filter);
    }

    protected Map<String, Object> getPaginationQueryParameters(P paginationParameter) {
        if (paginationParameter instanceof PaginationParameter) {
            return ((PaginationParameter)paginationParameter).getParameters();
        }
        return paginationParameter == null ? Collections.emptyMap() : Collections.singletonMap("parameter", paginationParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findSettingValue(String settingName) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, "SELECT e FROM Setting e WHERE e.name = ?0", new Object[]{settingName});
            query.setMaxResults(1);
            List results = query.getResultList();
            String string = results.isEmpty() ? null : ((Setting)results.get(0)).getValue();
            return string;
        }
    }

    protected Class<E> getEntityType() {
        return EzyGenerics.getGenericClassArguments((Type)((Object)((Object)this)).getClass().getGenericSuperclass(), (int)5)[3];
    }

    protected Class<R> getResultType() {
        return EzyGenerics.getGenericClassArguments((Type)((Object)((Object)this)).getClass().getGenericSuperclass(), (int)5)[4];
    }
}

