/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyMaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.youngmonkeys.ezyplatform.entity.AccessTokenType;
import org.youngmonkeys.ezyplatform.model.AdminAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.AdminNameModel;
import org.youngmonkeys.ezyplatform.model.AvatarCoverImageIdsModel;
import org.youngmonkeys.ezyplatform.model.UuidNameModel;

public interface AdminService {
    public AdminModel getAdminById(long var1);

    public Optional<AdminModel> getAdminByIdOptional(long var1);

    public AdminModel getAdminByUuid(String var1);

    public Optional<AdminModel> getAdminByUuidOptional(String var1);

    public AdminModel getAdminByUsername(String var1);

    public Optional<AdminModel> getAdminByUsernameOptional(String var1);

    public AdminNameModel getAdminNameById(long var1);

    public Map<Long, AdminNameModel> getAdminNameMapByIds(Collection<Long> var1);

    public UuidNameModel getAdminUuidNameById(long var1);

    public Map<Long, UuidNameModel> getAdminUuidNameMapByIds(Collection<Long> var1);

    public AvatarCoverImageIdsModel getAdminAvatarCoverImageIdsById(long var1);

    public UuidNameModel getAdminUuidNameByUuid(String var1);

    public Long getAdminIdByUuid(String var1);

    default public AdminModel getAdminByAccessToken(String accessToken) {
        return this.getAdminByAccessToken(accessToken, AccessTokenType.ACCESS_TOKEN_SINGLE_SET);
    }

    public AdminModel getAdminByAccessToken(String var1, Set<String> var2);

    public Long getAdminIdByAccessToken(String var1);

    default public Map<Long, AdminModel> getAdminMapByIds(Collection<Long> ids) {
        return EzyMaps.newHashMap(this.getAdminsByIds(ids), AdminModel::getId);
    }

    public List<AdminModel> getAdminsByIds(Collection<Long> var1);

    public List<AdminModel> getAdminsByUuids(Collection<String> var1);

    public Map<String, AdminModel> getAdminMapByUuids(Collection<String> var1);

    public AdminModel getAdminByEmail(String var1);

    public AdminModel getAdminByPhone(String var1);

    public AdminModel getAdminByUsernameOrEmail(String var1);

    public List<String> getAllAdminStatuses();

    default public long validateAdminAccessToken(String accessToken) {
        return this.validateAdminAccessToken(accessToken, AccessTokenType.ACCESS_TOKEN_SINGLE_SET);
    }

    public long validateAdminAccessToken(String var1, Set<String> var2);

    default public AdminAccessTokenModel getAdminAccessTokenOrThrowByAccessToken(String accessToken, boolean verifyStatus) {
        return this.getAdminAccessTokenOrThrowByAccessToken(accessToken, AccessTokenType.ACCESS_TOKEN_SINGLE_SET, verifyStatus);
    }

    public AdminAccessTokenModel getAdminAccessTokenOrThrowByAccessToken(String var1, Set<String> var2, boolean var3);

    default public AdminAccessTokenModel getAdminAccessTokenOrThrowByAccessToken(String accessToken, Set<String> tokenTypes) {
        return this.getAdminAccessTokenOrThrowByAccessToken(accessToken, tokenTypes, Boolean.FALSE);
    }

    default public AdminAccessTokenModel getAdminAccessTokenOrThrowByAccessToken(String accessToken) {
        return this.getAdminAccessTokenOrThrowByAccessToken(accessToken, Boolean.FALSE);
    }
}

