/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.function.EzyExceptionFunction;
import java.util.Collections;
import java.util.Map;
import org.youngmonkeys.ezyplatform.service.DictionaryService;
import org.youngmonkeys.ezyplatform.service.SettingService;

public class DefaultDictionaryService
implements DictionaryService {
    private final SettingService settingService;

    public DefaultDictionaryService(ObjectMapper objectMapper, SettingService settingService, Object ... components) {
        this.settingService = settingService;
        this.init(settingService, components);
        settingService.addValueConverter("ezyplatform_dictionary", (EzyExceptionFunction<String, Object>)((EzyExceptionFunction)value -> (Map)objectMapper.readValue(value, (TypeReference)new TypeReference<Map<String, String>>(){})));
        settingService.watchLastUpdatedTimeAndCache("ezyplatform_dictionary");
    }

    protected void init(SettingService settingService, Object ... components) {
    }

    @Override
    public String translate(String input) {
        Map dictionary = this.settingService.getCachedValue("ezyplatform_dictionary", Collections.emptyMap());
        return (String)dictionary.get(input);
    }

    @Override
    public String translateToAsciiString(String input) {
        Map dictionary = this.settingService.getCachedValue("ezyplatform_dictionary", Collections.emptyMap());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            String ch = String.valueOf(input.charAt(i));
            builder.append(dictionary.getOrDefault(ch, ch));
        }
        return builder.toString();
    }
}

