/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.function.EzyExceptionFunction;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.security.EzyAesCrypt;
import com.tvd12.ezyfox.security.EzyBase64;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.concurrent.Scheduler;
import org.youngmonkeys.ezyplatform.entity.Setting;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.repo.SettingRepository;
import org.youngmonkeys.ezyplatform.result.TypeResult;
import org.youngmonkeys.ezyplatform.service.SettingService;

public abstract class DefaultSettingService
extends EzyLoggable
implements SettingService {
    private final Scheduler scheduler;
    private final ObjectMapper objectMapper;
    private final SettingRepository settingRepository;
    protected final File encryptionKeysFile;
    private final AtomicLong encryptionKeysFileLastModified = new AtomicLong();
    protected final AtomicReference<String> encryptionKey = new AtomicReference();
    private final Map<String, Object> cachedValues = new ConcurrentHashMap<String, Object>();
    private final Map<String, Long> lastUpdatedTimeBySettingName = new ConcurrentHashMap<String, Long>();
    private final Map<String, LocalDateTime> lastChangedTimeBySettingName = new ConcurrentHashMap<String, LocalDateTime>();
    private final Map<String, EzyExceptionFunction<String, Object>> converters = new ConcurrentHashMap<String, EzyExceptionFunction<String, Object>>();
    public static final LocalDateTime DEFAULT_LAST_CHANGED_TIME = LocalDateTime.of(1970, 1, 1, 0, 0);
    public static final String DEFAULT_ENCRYPTION_KEY = "KSYzjcc8nqrBk8jXtW4QaMpr2suBU9vY";
    public static final String LAST_UPDATE_TIME_SUFFIX = "_last_updated_time";

    public DefaultSettingService(Scheduler scheduler, ObjectMapper objectMapper, FileSystemManager fileSystemManager, SettingRepository settingRepository) {
        this.scheduler = scheduler;
        this.objectMapper = objectMapper;
        this.settingRepository = settingRepository;
        this.encryptionKeysFile = fileSystemManager.concatWithEzyHome(Paths.get("settings", "encryption-keys.txt"));
        this.readAndSetEncryptionKeyFromFile();
        this.watchEncryptionKeysFile();
    }

    protected void watchEncryptionKeysFile() {
        this.scheduler.scheduleAtFixRate(() -> {
            long lastModified;
            if (this.encryptionKeysFile.exists() && (lastModified = this.encryptionKeysFile.lastModified()) != this.encryptionKeysFileLastModified.get()) {
                this.readAndSetEncryptionKeyFromFile();
            }
        }, 5000L, 300L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addValueConverter(String settingName, EzyExceptionFunction<String, Object> converter) {
        this.converters.put(settingName, converter);
    }

    @Override
    public void scheduleCacheValue(String settingName, int periodInSecond) {
        this.scheduler.scheduleAtFixRate(() -> this.cacheValueIfNotNull(settingName, this.fetchAndCacheLastChangedTimeAndParseValue(settingName)), 0L, periodInSecond, TimeUnit.SECONDS);
    }

    @Override
    public void watchLastUpdatedTime(String settingName, int periodInSecond, Runnable onLastUpdatedTimeChange) {
        Runnable func = () -> this.fetchAndUpdateLastUpdatedTime(settingName, onLastUpdatedTimeChange);
        func.run();
        this.scheduler.scheduleAtFixRate(func, periodInSecond, periodInSecond, TimeUnit.SECONDS);
    }

    @Override
    public void watchLastUpdatedTimeAndCache(String settingName, int periodInSecond) {
        this.watchLastUpdatedTime(settingName, periodInSecond, () -> this.cacheValueIfNotNull(settingName, this.fetchAndCacheLastChangedTimeAndParseValue(settingName)));
    }

    @Override
    public String decryptValue(String encryptedSettingValue) {
        return this.decryptValue(encryptedSettingValue, this.getEncryptionKey());
    }

    protected String decryptValue(String encryptedSettingValue, String encryptionKey) {
        try {
            return new String(EzyAesCrypt.getDefault().decrypt(EzyBase64.decode((String)encryptedSettingValue), encryptionKey.getBytes()));
        }
        catch (Exception e) {
            return encryptedSettingValue;
        }
    }

    public List<String> getAllDataTypes() {
        return this.settingRepository.findAllDataTypes().stream().map(TypeResult::getType).filter(EzyStrings::isNotBlank).collect(Collectors.toList());
    }

    @Override
    public <T> T getObjectValue(String settingName, Class<T> objectType) {
        String textValue = this.getTextValue(settingName);
        if (textValue == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(textValue, objectType);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("can not read setting value to: {}", objectType, (Object)e);
            return null;
        }
    }

    @Override
    public String getDecryptionValue(String settingName) {
        String textValue = this.getTextValue(settingName);
        if (textValue == null) {
            return null;
        }
        return this.decryptValue(textValue);
    }

    @Override
    public Optional<String> getSettingValue(String settingName) {
        return this.settingRepository.findByFieldOptional("name", settingName).map(Setting::getValue);
    }

    @Override
    public <T> T getCachedValue(String settingName, T defaultValue) {
        Object value = this.cachedValues.get(settingName);
        return (T)(value != null ? value : defaultValue);
    }

    protected <T> T getAndParseValue(String settingName) {
        return this.getSettingValue(settingName).map(it -> this.convertValue(settingName, (String)it)).orElse(null);
    }

    protected <T> T convertValue(String settingName, String settingValue) {
        try {
            EzyExceptionFunction<String, Object> converter = this.converters.get(settingName);
            return (T)(converter == null ? settingValue : converter.apply((Object)settingValue));
        }
        catch (Exception e) {
            this.logger.warn("convert setting: {} value: {} error", new Object[]{settingName, settingValue, e});
            return null;
        }
    }

    private <T> T fetchAndCacheLastChangedTimeAndParseValue(String settingName) {
        LocalDateTime lastChangedTime = this.lastChangedTimeBySettingName.getOrDefault(settingName, DEFAULT_LAST_CHANGED_TIME);
        Setting setting = this.getChangedSetting(settingName, lastChangedTime);
        if (setting == null) {
            return null;
        }
        this.lastChangedTimeBySettingName.put(settingName, setting.getUpdatedAt());
        return this.convertValue(settingName, setting.getValue());
    }

    protected Setting getChangedSetting(String settingName, LocalDateTime lastChangedTime) {
        return this.settingRepository.findByNameAndUpdatedAtGt(settingName, lastChangedTime);
    }

    public String getEncryptionKey() {
        return this.encryptionKey.get();
    }

    private void readAndSetEncryptionKeyFromFile() {
        String keyFromFile = this.readEncryptionKeyFile();
        if (EzyStrings.isBlank((String)keyFromFile)) {
            if (this.encryptionKey.get() == null) {
                this.encryptionKey.set(DEFAULT_ENCRYPTION_KEY);
            }
        } else {
            this.encryptionKey.set(keyFromFile);
        }
    }

    private String readEncryptionKeyFile() {
        if (this.encryptionKeysFile.exists()) {
            try {
                List<String> lines = Files.readAllLines(this.encryptionKeysFile.toPath());
                this.encryptionKeysFileLastModified.set(this.encryptionKeysFile.lastModified());
                return !lines.isEmpty() ? lines.get(0) : null;
            }
            catch (IOException e) {
                this.logger.warn("read encryption key file error", (Throwable)e);
            }
        }
        return null;
    }

    public void cacheValueIfNotNull(String settingName, Object value) {
        if (value != null) {
            this.cachedValues.put(settingName, value);
        }
    }

    private void fetchAndUpdateLastUpdatedTime(String settingName, Runnable onLastUpdatedTimeChange) {
        String key = settingName + LAST_UPDATE_TIME_SUFFIX;
        long settingValue = this.getLongValue(key);
        long currentValue = this.lastUpdatedTimeBySettingName.getOrDefault(settingName, 0L);
        if (currentValue == 0L && settingValue > 0L || currentValue != 0L && settingValue > currentValue) {
            this.lastUpdatedTimeBySettingName.put(settingName, settingValue);
            EzyProcessor.processWithLogException(onLastUpdatedTimeChange::run, (boolean)true);
        }
    }
}

