/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.Next;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultResultToModelConverter;
import org.youngmonkeys.ezyplatform.entity.AccessTokenStatus;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.entity.UserAccessToken;
import org.youngmonkeys.ezyplatform.exception.UserAccessTokenExpiredException;
import org.youngmonkeys.ezyplatform.exception.UserInvalidAccessTokenException;
import org.youngmonkeys.ezyplatform.exception.UserNotFoundException;
import org.youngmonkeys.ezyplatform.exception.UserWaiting2FaAccessTokenException;
import org.youngmonkeys.ezyplatform.model.UserAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.model.UserNameModel;
import org.youngmonkeys.ezyplatform.model.UuidNameModel;
import org.youngmonkeys.ezyplatform.repo.UserAccessTokenRepository;
import org.youngmonkeys.ezyplatform.repo.UserRepository;
import org.youngmonkeys.ezyplatform.result.IdNameResult;
import org.youngmonkeys.ezyplatform.result.IdResult;
import org.youngmonkeys.ezyplatform.result.IdUuidNameResult;
import org.youngmonkeys.ezyplatform.result.IdUuidResult;
import org.youngmonkeys.ezyplatform.result.StatusResult;
import org.youngmonkeys.ezyplatform.service.UserAccessTokenService;
import org.youngmonkeys.ezyplatform.service.UserService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.util.StringConverters;

public class DefaultUserService
implements UserService {
    private final ClockProxy clock;
    private final UserAccessTokenService accessTokenService;
    private final UserRepository userRepository;
    private final UserAccessTokenRepository accessTokenRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;
    private final DefaultModelToEntityConverter modelToEntityConverter;
    private final DefaultResultToModelConverter resultToModelConverter;

    public UserAccessTokenModel newUserAccessToken(long userId, String tokenType, long tokenExpiredTime, TimeUnit tokenExpiredTimeUnit, String status) {
        String token = this.accessTokenService.generateAccessToken(userId);
        UserAccessToken accessToken = this.modelToEntityConverter.toUserAccessTokenEntity(userId, token, tokenType, tokenExpiredTime, tokenExpiredTimeUnit, status);
        this.accessTokenRepository.save(accessToken);
        return this.entityToModelConverter.toModel(accessToken);
    }

    public void updateUserEmail(long userId, String email) {
        User user = this.getUserEntityByIdOrThrow(userId);
        user.setEmail(StringConverters.trimOrNull(email));
        user.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(user);
    }

    public void updateUserPhone(long userId, String phone) {
        User user = this.getUserEntityByIdOrThrow(userId);
        user.setPhone(StringConverters.trimOrNull(phone));
        user.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(user);
    }

    public void updateUserDisplayName(long userId, String displayName) {
        User user = this.getUserEntityByIdOrThrow(userId);
        user.setDisplayName(StringConverters.trimOrNull(displayName));
        user.setUpdatedAt(this.clock.nowDateTime());
        this.userRepository.save(user);
    }

    public List<String> getAllUserStatuses() {
        return this.userRepository.findAllUserStatuses().stream().map(StatusResult::getStatus).filter(EzyStrings::isNotBlank).collect(Collectors.toList());
    }

    @Override
    public UserModel getUserById(long id) {
        return this.userRepository.findByIdOptional(id).map(this.entityToModelConverter::toModel).orElse(null);
    }

    @Override
    public UserModel getUserByUuid(String uuid) {
        return this.userRepository.findByFieldOptional("uuid", uuid).map(this.entityToModelConverter::toModel).orElse(null);
    }

    @Override
    public UserModel getUserByUsername(String username) {
        return this.userRepository.findByFieldOptional("username", username).map(this.entityToModelConverter::toModel).orElse(null);
    }

    @Override
    public UserModel getUserByEmail(String email) {
        return this.userRepository.findByFieldOptional("email", email).map(this.entityToModelConverter::toModel).orElse(null);
    }

    @Override
    public UserModel getUserByPhone(String phone) {
        return this.userRepository.findByFieldOptional("phone", phone).map(this.entityToModelConverter::toModel).orElse(null);
    }

    @Override
    public UserModel getUserByAccessToken(String accessToken, Set<String> tokenTypes) {
        long userId = this.validateUserAccessToken(accessToken);
        return this.getUserById(userId);
    }

    @Override
    public String getUserStatusById(long userId) {
        StatusResult result = this.userRepository.findStatusById(userId);
        return result != null ? result.getStatus() : CommonConstants.NULL_STRING;
    }

    @Override
    public List<UserModel> getUserListByIds(Collection<Long> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        return EzyLists.newArrayList((Collection)this.userRepository.findListByIds(userIds), this.entityToModelConverter::toModel);
    }

    @Override
    public List<UserModel> getUserListByUsernames(Collection<String> usernames) {
        if (usernames.isEmpty()) {
            return Collections.emptyList();
        }
        return EzyLists.newArrayList(this.userRepository.findByUsernameIn(usernames), this.entityToModelConverter::toModel);
    }

    @Override
    public List<UserModel> getUserListByPhones(Collection<String> phones) {
        if (phones.isEmpty()) {
            return Collections.emptyList();
        }
        return EzyLists.newArrayList(this.userRepository.findByPhoneIn(phones), this.entityToModelConverter::toModel);
    }

    @Override
    public List<UserModel> getUserListByEmails(Collection<String> emails) {
        if (emails.isEmpty()) {
            return Collections.emptyList();
        }
        return EzyLists.newArrayList(this.userRepository.findByEmailIn(emails), this.entityToModelConverter::toModel);
    }

    @Override
    public List<UserModel> getUserListByUuids(Collection<String> uuids) {
        if (uuids.isEmpty()) {
            return Collections.emptyList();
        }
        return EzyLists.newArrayList(this.userRepository.findByUuidIn(uuids), this.entityToModelConverter::toModel);
    }

    @Override
    public UserNameModel getUsernameById(long userId) {
        return this.resultToModelConverter.toUserNameModel(this.userRepository.findUserIdAndNameById(userId));
    }

    @Override
    public Map<Long, UserNameModel> getUsernameMapByIds(Collection<Long> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<IdNameResult> results = this.userRepository.findUserIdAndNameByIds(userIds);
        return results.stream().collect(Collectors.toMap(IdNameResult::getId, this.resultToModelConverter::toUserNameModel));
    }

    @Override
    public Map<String, UserNameModel> getUsernameMapByUsernames(Collection<String> userNames) {
        if (userNames.isEmpty()) {
            return Collections.emptyMap();
        }
        List<IdNameResult> results = this.userRepository.findUserIdAndNameByUsernames(userNames);
        return results.stream().collect(Collectors.toMap(IdNameResult::getUsername, this.resultToModelConverter::toUserNameModel));
    }

    @Override
    public UuidNameModel getUserUuidNameById(long userId) {
        return this.resultToModelConverter.toModel(this.userRepository.findUserUuidNameById(userId));
    }

    @Override
    public Map<Long, UuidNameModel> getUserUuidNameMapByIds(Collection<Long> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.userRepository.findUserUuidNamesByIds(userIds).stream().collect(Collectors.toMap(IdUuidNameResult::getId, this.resultToModelConverter::toModel));
    }

    @Override
    public UuidNameModel getUserUuidNameByUuid(String uuid) {
        return this.resultToModelConverter.toModel(this.userRepository.findUserUuidNameByUuid(uuid));
    }

    @Override
    public long getUserIdByUsername(String username) {
        IdResult result = this.userRepository.findUserIdByUsername(username);
        return result != null ? result.getId() : 0L;
    }

    @Override
    public long getUserIdByEmail(String email) {
        IdResult result = this.userRepository.findUserIdByEmail(email);
        return result != null ? result.getId() : 0L;
    }

    @Override
    public long getUserIdByPhone(String phone) {
        IdResult result = this.userRepository.findUserIdByPhone(phone);
        return result != null ? result.getId() : 0L;
    }

    @Override
    public Long getUserIdByUuid(String uuid) {
        IdResult result = this.userRepository.findUserIdByUuid(uuid);
        return result != null ? Long.valueOf(result.getId()) : null;
    }

    @Override
    public Map<String, Long> getUserIdMapByUuids(Collection<String> uuids) {
        if (uuids.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.userRepository.findUserIdsByUuids(uuids).stream().collect(Collectors.toMap(IdUuidResult::getUuid, IdUuidResult::getId));
    }

    @Override
    public Long getUserIdByAccessToken(String accessToken) {
        UserAccessToken entity;
        if (accessToken != null && (entity = (UserAccessToken)this.accessTokenRepository.findById(accessToken)) != null) {
            return entity.getUserId();
        }
        return null;
    }

    @Override
    public long validateUserAccessToken(String accessToken, Set<String> tokenTypes) {
        return this.getAccessTokenEntityOrThrowByAccessToken(accessToken, tokenTypes, Boolean.TRUE).getUserId();
    }

    @Override
    public UserAccessTokenModel getUserAccessTokenByAccessToken(String accessToken) {
        return this.entityToModelConverter.toModel((UserAccessToken)this.accessTokenRepository.findById(accessToken));
    }

    @Override
    public UserAccessTokenModel getUserAccessTokenOrThrowByAccessToken(String accessToken, Set<String> tokenTypes, boolean verifyStatus) {
        return this.entityToModelConverter.toModel(this.getAccessTokenEntityOrThrowByAccessToken(accessToken, tokenTypes, verifyStatus));
    }

    protected UserAccessToken getAccessTokenEntityOrThrowByAccessToken(String accessToken, Set<String> tokenTypes, boolean verifyStatus) {
        if (EzyStrings.isBlank((String)accessToken)) {
            throw new UserInvalidAccessTokenException(accessToken);
        }
        long userId = this.accessTokenService.extractUserId(accessToken);
        if (userId <= 0L) {
            throw new UserInvalidAccessTokenException(accessToken);
        }
        UserAccessToken entity = (UserAccessToken)this.accessTokenRepository.findById(accessToken);
        if (entity == null) {
            throw new UserInvalidAccessTokenException(accessToken);
        }
        String tokenType = entity.getTokenType();
        if (!tokenTypes.isEmpty() && EzyStrings.isBlank((String)tokenType) || !tokenTypes.contains(tokenType)) {
            throw new UserInvalidAccessTokenException(accessToken);
        }
        if (userId != entity.getUserId()) {
            throw new UserInvalidAccessTokenException(accessToken);
        }
        String status = entity.getStatus();
        if (verifyStatus && !AccessTokenStatus.ACTIVATED.equalsValue(status) && !AccessTokenStatus.ACTIVATED_2FA.equalsValue(status)) {
            if (AccessTokenStatus.WAITING_2FA.equalsValue(status)) {
                throw new UserWaiting2FaAccessTokenException(accessToken);
            }
            throw new UserInvalidAccessTokenException(accessToken);
        }
        LocalDateTime now = this.clock.nowDateTime();
        if (now.isAfter(entity.getExpiredAt())) {
            throw new UserAccessTokenExpiredException(accessToken);
        }
        return entity;
    }

    @Override
    public boolean containsUserById(long id) {
        return this.userRepository.containsById(id);
    }

    @Override
    public boolean containsUserByUsername(String username) {
        return this.userRepository.containsByField("username", username);
    }

    @Override
    public List<UserNameModel> simpleSearch(String keyword, int limit) {
        List<IdNameResult> results = this.userRepository.findUsernameByUniqueKeyword(keyword, Next.limit((long)limit));
        if (results.isEmpty()) {
            results = this.userRepository.findUsernameByKeyword(keyword, Next.limit((long)limit));
        }
        return EzyLists.newArrayList(results, this.resultToModelConverter::toUserNameModel);
    }

    @Override
    public List<UserNameModel> simpleSearch(Collection<String> keywords, int limit) {
        List<IdNameResult> results = this.userRepository.findUsernameByUniqueKeywords(keywords, Next.limit((long)limit));
        if (results.isEmpty()) {
            results = this.userRepository.findUsernameByKeywords(keywords, Next.limit((long)limit));
        }
        return EzyLists.newArrayList(results, this.resultToModelConverter::toUserNameModel);
    }

    @Override
    public List<UserNameModel> simpleSearchWithKeywordPrefix(String keywordPrefix, int limit) {
        List<IdNameResult> results = this.userRepository.findUsernameByKeywordPrefix(keywordPrefix, Next.limit((long)limit));
        return EzyLists.newArrayList(results, this.resultToModelConverter::toUserNameModel);
    }

    @Override
    public List<UserNameModel> simpleSearchWithRoleIds(Collection<Long> roleIds, String keyword, int limit) {
        return EzyLists.newArrayList(this.userRepository.findUsernameByKeywordAndRoleIds(roleIds, keyword, Next.limit((long)limit)), this.resultToModelConverter::toUserNameModel);
    }

    @Override
    public List<UserNameModel> simpleSearchWithRoleIds(Collection<Long> roleIds, Collection<String> keywords, int limit) {
        return EzyLists.newArrayList(this.userRepository.findUsernameByKeywordsAndRoleIds(roleIds, keywords, Next.limit((long)limit)), this.resultToModelConverter::toUserNameModel);
    }

    @Override
    public List<UserNameModel> simpleSearchWithRoleIdsAndKeywordPrefix(Collection<Long> roleIds, String keywordPrefix, int limit) {
        return EzyLists.newArrayList(this.userRepository.findUsernameByKeywordPrefixAndRoleIds(roleIds, keywordPrefix, Next.limit((long)limit)), this.resultToModelConverter::toUserNameModel);
    }

    @Override
    public List<UserNameModel> simpleSearchWithRoleNames(Collection<String> roleNames, String keyword, int limit) {
        return EzyLists.newArrayList(this.userRepository.findUsernameByKeywordAndRoleNames(roleNames, keyword, Next.limit((long)limit)), this.resultToModelConverter::toUserNameModel);
    }

    @Override
    public List<UserNameModel> simpleSearchWithRoleNames(Collection<String> roleNames, Collection<String> keywords, int limit) {
        return EzyLists.newArrayList(this.userRepository.findUsernameByKeywordsAndRoleNames(roleNames, keywords, Next.limit((long)limit)), this.resultToModelConverter::toUserNameModel);
    }

    @Override
    public List<UserNameModel> simpleSearchWithRoleNamesAndKeywordPrefix(Collection<String> roleNames, String keywordPrefix, int limit) {
        return EzyLists.newArrayList(this.userRepository.findUsernameByKeywordPrefixAndRoleNames(roleNames, keywordPrefix, Next.limit((long)limit)), this.resultToModelConverter::toUserNameModel);
    }

    @Override
    public long countUsersByStatus(String status) {
        return this.userRepository.countByStatus(status);
    }

    protected User getUserEntityByIdOrThrow(long userId) {
        User entity = (User)this.userRepository.findById(userId);
        if (entity == null) {
            throw new UserNotFoundException(userId);
        }
        return entity;
    }

    @Generated
    public DefaultUserService(ClockProxy clock, UserAccessTokenService accessTokenService, UserRepository userRepository, UserAccessTokenRepository accessTokenRepository, DefaultEntityToModelConverter entityToModelConverter, DefaultModelToEntityConverter modelToEntityConverter, DefaultResultToModelConverter resultToModelConverter) {
        this.clock = clock;
        this.accessTokenService = accessTokenService;
        this.userRepository = userRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
        this.resultToModelConverter = resultToModelConverter;
    }
}

