/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.model.WebLanguageModel;
import org.youngmonkeys.ezyplatform.service.LanguageService;

public interface WebLanguageService
extends LanguageService {
    public WebLanguageModel[] getLanguages();

    default public List<WebLanguageModel> getLanguageList() {
        return Arrays.asList(this.getLanguages());
    }

    default public List<WebLanguageModel> getActiveLanguages() {
        return Arrays.stream(this.getLanguages()).filter(WebLanguageModel::isActive).collect(Collectors.toList());
    }

    default public WebLanguageModel getLanguageByCode(String code) {
        for (WebLanguageModel language : this.getLanguages()) {
            if (!language.getCode().equals(code)) continue;
            return language;
        }
        return null;
    }

    default public Map<String, WebLanguageModel> getLanguageMap() {
        return Arrays.stream(this.getLanguages()).collect(Collectors.toMap(WebLanguageModel::getCode, it -> it));
    }

    default public List<WebLanguageModel> getLanguagesByCodes(Collection<String> codes) {
        Map<String, WebLanguageModel> languageMap = this.getLanguageMap();
        return codes.stream().map(languageMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

