/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.asm;

import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.server.core.reflect.ExceptionHandlerMethod;
import com.tvd12.ezyhttp.server.core.reflect.HandlerMethod;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.lang.reflect.Parameter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AbstractHandlerImplementer<H extends HandlerMethod>
extends EzyLoggable {
    protected final H handlerMethod;

    public AbstractHandlerImplementer(H handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    protected void appendHandleExceptionMethodArguments(ExceptionHandlerMethod method, EzyInstruction instruction, Class<?> exceptionClass) {
        Parameter[] parameters;
        int paramCount = 0;
        for (Parameter parameter : parameters = method.getParameters()) {
            Class<?> parameterType = parameter.getType();
            if (parameterType == RequestArguments.class) {
                instruction.append("arg0");
            } else if (parameterType == HttpServletRequest.class) {
                instruction.append("arg0.getRequest()");
            } else if (parameterType == HttpServletResponse.class) {
                instruction.append("arg0.getResponse()");
            } else if (Throwable.class.isAssignableFrom(parameterType)) {
                instruction.brackets(exceptionClass).append("arg1");
            } else if (parameterType == Boolean.TYPE) {
                instruction.append("false");
            } else if (parameterType.isPrimitive()) {
                instruction.append("0");
            } else {
                instruction.append("null");
            }
            if (paramCount++ >= parameters.length - 1) continue;
            instruction.append(", ");
        }
    }
}

