/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.view;

import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.Cookie;
import lombok.Generated;

public class View {
    private Locale locale;
    private String template;
    private String contentType;
    private final List<Cookie> cookies;
    private final Map<String, String> headers;
    private final Map<String, Object> variables;

    protected View(Builder builder) {
        this.template = builder.template;
        this.locale = builder.locale;
        this.variables = builder.variables;
        this.contentType = builder.contentType;
        this.cookies = builder.cookies;
        this.headers = builder.headers;
    }

    public static View of(String template) {
        return View.builder().template(template).build();
    }

    public boolean containsVariable(String name) {
        Object value = this.variables.get(name);
        return value != null;
    }

    public <T> T getVariable(String name) {
        return (T)this.variables.get(name);
    }

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    public void setVariableIfAbsent(String name, Object value) {
        this.variables.putIfAbsent(name, value);
    }

    public void setVariableIfAbsent(String name, Supplier<Object> valueSupplier) {
        this.variables.computeIfAbsent(name, k -> valueSupplier.get());
    }

    public void setVariables(Map<String, Object> variables) {
        if (variables != null) {
            this.variables.putAll(variables);
        }
    }

    public static void appendToVariable(Map<String, Object> variables, String variableName, Object value) {
        if (value != null) {
            ((List)variables.computeIfAbsent(variableName, k -> new ArrayList())).add(value);
        }
    }

    public void appendToVariable(String name, Object value) {
        View.appendToVariable(this.variables, name, value);
    }

    public void appendValueToVariable(String name, Object value) {
        View.appendToVariable(this.variables, name, value);
    }

    public void appendValuesToVariable(String name, Object[] values) {
        for (Object value : values) {
            View.appendToVariable(this.variables, name, value);
        }
    }

    public void appendValuesToVariable(String name, Collection values) {
        for (Object value : values) {
            View.appendToVariable(this.variables, name, value);
        }
    }

    public void putKeyValueToVariable(String variableName, String key, Object value) {
        View.putKeyValueToVariable(this.variables, variableName, key, value);
    }

    public static void putKeyValueToVariable(Map<String, Object> variables, String variableName, String key, Object value) {
        if (key != null && value != null) {
            ((Map)variables.computeIfAbsent(variableName, k -> new HashMap())).put(key, value);
        }
    }

    public void putKeyValuesToVariable(String variableName, Map<String, Object> keyValues) {
        for (Map.Entry<String, Object> e : keyValues.entrySet()) {
            this.putKeyValueToVariable(variableName, e.getKey(), e.getValue());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public String getTemplate() {
        return this.template;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public List<Cookie> getCookies() {
        return this.cookies;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Generated
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Generated
    public void setTemplate(String template) {
        this.template = template;
    }

    @Generated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public static class Builder
    implements EzyBuilder<View> {
        private String template;
        private List<Cookie> cookies;
        private Map<String, String> headers;
        private Locale locale = Locale.ENGLISH;
        private String contentType = "text/html; charset=utf-8";
        private final Map<String, Object> variables = new HashMap<String, Object>();

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            return this.locale(new Locale(locale));
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder addVariable(String name, Object value) {
            this.variables.put(name, value);
            return this;
        }

        public Builder addVariables(Map<String, Object> variables) {
            if (variables != null) {
                this.variables.putAll(variables);
            }
            return this;
        }

        public Builder appendToVariable(String variableName, Object value) {
            View.appendToVariable(this.variables, variableName, value);
            return this;
        }

        public Builder appendValueToVariable(String variableName, Object value) {
            View.appendToVariable(this.variables, variableName, value);
            return this;
        }

        public Builder appendValuesToVariable(String variableName, Object[] values) {
            for (Object value : values) {
                View.appendToVariable(this.variables, variableName, value);
            }
            return this;
        }

        public Builder appendValuesToVariable(String variableName, Collection values) {
            for (Object value : values) {
                View.appendToVariable(this.variables, variableName, value);
            }
            return this;
        }

        public Builder putKeyValueToVariable(String variableName, String key, Object value) {
            View.putKeyValueToVariable(this.variables, variableName, key, value);
            return this;
        }

        public Builder putKeyValuesToVariable(String variableName, Map<String, Object> keyValues) {
            for (Map.Entry<String, Object> e : keyValues.entrySet()) {
                this.putKeyValueToVariable(variableName, e.getKey(), e.getValue());
            }
            return this;
        }

        public Builder addHeader(String name, Object value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(name, value.toString());
            return this;
        }

        public Builder addHeaders(Map<String, Object> headers) {
            for (Map.Entry<String, Object> e : headers.entrySet()) {
                this.addHeader(e.getKey(), e.getValue());
            }
            return this;
        }

        public Builder addCookie(Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new LinkedList<Cookie>();
            }
            this.cookies.add(cookie);
            return this;
        }

        public Builder addCookie(String name, Object value) {
            return this.addCookie(new Cookie(name, value.toString()));
        }

        public Builder addCookie(String name, Object value, String path) {
            Cookie cookie = new Cookie(name, value.toString());
            cookie.setPath(path);
            return this.addCookie(cookie);
        }

        public View build() {
            if (this.template == null) {
                throw new NullPointerException("template can not be null");
            }
            if (this.cookies == null) {
                this.cookies = Collections.emptyList();
            }
            if (this.headers == null) {
                this.headers = Collections.emptyMap();
            }
            return new View(this);
        }
    }
}

