/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import java.time.LocalDateTime;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.model.AdminActivityHistoryModel;
import org.youngmonkeys.ezyplatform.admin.pagination.AdminAdminActivityFilter;
import org.youngmonkeys.ezyplatform.admin.service.AdminPaginationAdminActivityService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.model.LocalDateTimeRangeModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.pagination.PaginationModelFetchers;
import org.youngmonkeys.ezyplatform.service.PaginationService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.util.StringConverters;

@Api
@Authenticated
@Controller(value="/api/v1")
public class AdminApiAdminActivitiesController {
    private final ClockProxy clock;
    private final AdminPaginationAdminActivityService paginationAdminActivityService;
    private final AdminCommonValidator commonValidator;

    @DoGet(value="/admins/me/activities")
    public PaginationModel<AdminActivityHistoryModel> adminsMeActivities(@AdminId long adminId, @RequestParam(value="method") String method, @RequestParam(value="keyword") String keyword, @RequestParam(value="createdAtStartInclusive") Long createdAtStartInclusive, @RequestParam(value="createdAtEndExclusive") Long createdAtEndExclusive, @RequestParam(value="createdAtEndInclusive") Long createdAtEndInclusive, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="12") int limit) {
        return this.getAdminActivityPagination(adminId, method, keyword, createdAtStartInclusive, createdAtEndExclusive, createdAtEndInclusive, nextPageToken, prevPageToken, lastPage, limit);
    }

    @EzyFeature(value="admin_management")
    @DoGet(value="/admins/{adminId}/activities")
    public PaginationModel<AdminActivityHistoryModel> adminsAdminIdActivities(@PathVariable(value="adminId") long adminId, @RequestParam(value="method") String method, @RequestParam(value="keyword") String keyword, @RequestParam(value="createdAtStartInclusive") Long createdAtStartInclusive, @RequestParam(value="createdAtEndExclusive") Long createdAtEndExclusive, @RequestParam(value="createdAtEndInclusive") Long createdAtEndInclusive, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="12") int limit) {
        return this.getAdminActivityPagination(adminId, method, keyword, createdAtStartInclusive, createdAtEndExclusive, createdAtEndInclusive, nextPageToken, prevPageToken, lastPage, limit);
    }

    private PaginationModel<AdminActivityHistoryModel> getAdminActivityPagination(long adminId, String method, String keyword, Long createdAtStartInclusive, Long createdAtEndExclusive, Long createdAtEndInclusive, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        LocalDateTimeRangeModel createdAtTimeRangeModel;
        this.commonValidator.validatePageSize(limit);
        LocalDateTime createdAtEndExclusiveValue = null;
        LocalDateTime createdAtEndInclusiveValue = null;
        if (createdAtEndExclusive != null) {
            createdAtTimeRangeModel = LocalDateTimeRangeModel.parseTimestamps((ClockProxy)this.clock, (Long)createdAtStartInclusive, (Long)createdAtEndExclusive);
            createdAtEndExclusiveValue = createdAtTimeRangeModel.getEnd();
        } else {
            createdAtTimeRangeModel = LocalDateTimeRangeModel.parseTimestamps((ClockProxy)this.clock, (Long)createdAtStartInclusive, (Long)createdAtEndInclusive);
            createdAtEndInclusiveValue = createdAtTimeRangeModel.getEnd();
        }
        AdminAdminActivityFilter filter = AdminAdminActivityFilter.builder().adminId(adminId).method(method).keyword(StringConverters.trimOrNull((String)keyword)).createdAtStartInclusive(createdAtTimeRangeModel.getStart()).createdAtEndExclusive(createdAtEndExclusiveValue).createdAtEndInclusive(createdAtEndInclusiveValue).build();
        return PaginationModelFetchers.getPaginationModel((PaginationService)this.paginationAdminActivityService, (Object)filter, (String)nextPageToken, (String)prevPageToken, (boolean)lastPage, (int)limit);
    }

    @Generated
    public AdminApiAdminActivitiesController(ClockProxy clock, AdminPaginationAdminActivityService paginationAdminActivityService, AdminCommonValidator commonValidator) {
        this.clock = clock;
        this.paginationAdminActivityService = paginationAdminActivityService;
        this.commonValidator = commonValidator;
    }
}

