/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Async;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminMediaControllerService;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAvatarRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateCoverImageRequest;
import org.youngmonkeys.ezyplatform.admin.response.AdminMediaDetailsResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.admin.validator.AdminMediaValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.entity.MediaStatus;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.pagination.DefaultMediaFilter;
import org.youngmonkeys.ezyplatform.pagination.MediaFilter;
import org.youngmonkeys.ezyplatform.request.UpdateMediaRequest;
import org.youngmonkeys.ezyplatform.response.MediaResponse;
import org.youngmonkeys.ezyplatform.util.StringConverters;

@Api
@Authenticated
@Controller(value="/api/v1")
public class AdminApiAdminMeMediaController {
    private final AdminAdminService adminService;
    private final AdminMediaControllerService mediaControllerService;
    private final AdminSettingService settingService;
    private final AdminCommonValidator commonValidator;
    private final AdminMediaValidator mediaValidator;

    @Async
    @DoPost(value="/me/media/{id}/replace")
    public void meMediaIdReplacePost(HttpServletRequest request, HttpServletResponse response, @AdminId long adminId, @PathVariable long mediaId) throws Exception {
        this.mediaControllerService.replaceMedia(request, response, mediaId, media -> media.getOwnerAdminId() == adminId);
    }

    @DoPut(value="/me/media/{id}")
    public ResponseEntity mediaIdPut(@AdminId long adminId, @PathVariable long mediaId, @RequestBody UpdateMediaRequest request) {
        this.mediaControllerService.updateMedia(mediaId, request, media -> media.getOwnerAdminId() == adminId);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/me/media/{id}")
    public ResponseEntity mediaMediaIdDelete(@AdminId long adminId, @PathVariable long mediaId) {
        this.mediaValidator.validateOwnerAdminMedia(adminId, mediaId);
        this.mediaControllerService.removeMediaById(mediaId, Boolean.TRUE);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/me/media/{id}/restore")
    public ResponseEntity meMediaIdRestorePut(@AdminId long adminId, @PathVariable long mediaId) {
        this.mediaValidator.validateOwnerAdminMedia(adminId, mediaId);
        this.mediaControllerService.updateMediaStatus(mediaId, MediaStatus.ADDED.toString());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/admins/me/update-avatar")
    public ResponseEntity adminsMeUpdateAvatarPut(@AdminId long adminId, @RequestBody UpdateAvatarRequest request) {
        long avatarId = request.getAvatarId();
        this.commonValidator.validateId("avatarId", avatarId);
        this.adminService.updateAvatar(adminId, avatarId);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/admins/me/update-cover-image")
    public ResponseEntity adminsMeUpdateCoverImagePut(@AdminId long adminId, @RequestBody UpdateCoverImageRequest request) {
        long coverImageId = request.getCoverImageId();
        this.commonValidator.validateId("coverImageId", coverImageId);
        this.adminService.updateCoverImage(adminId, coverImageId);
        return ResponseEntity.noContent();
    }

    @Async
    @DoGet(value="/me/media/{name}")
    public void meMediaNameGet(RequestArguments requestArguments, @AdminId long adminId, @PathVariable String name) throws Exception {
        this.mediaValidator.validateAdminMedia(adminId, name);
        this.mediaControllerService.getMediaByName(requestArguments, name, Boolean.TRUE, media -> media.getOwnerAdminId() == adminId);
    }

    @DoGet(value="/me/media/{id}/details")
    public AdminMediaDetailsResponse mediaIdDetailsGet(@AdminId long adminId, @PathVariable long mediaId) {
        this.mediaValidator.validateAdminMedia(adminId, mediaId);
        return this.mediaControllerService.getAdminMediaDetailsById(mediaId, media -> media.getOwnerAdminId() == adminId);
    }

    @DoGet(value="/me/media/list")
    public PaginationModel<MediaResponse> meMediaListGet(@AdminId long adminId, @RequestParam(value="type") String type, @RequestParam(value="status") String status, @RequestParam(value="keyword") String keyword, @RequestParam(value="sortOrder") String sortOrder, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        String trimedStatus = StringConverters.trimOrNull((String)status);
        String trimmedKeyword = StringConverters.trimOrNull((String)keyword);
        return this.mediaControllerService.getMediaList((MediaFilter)DefaultMediaFilter.builder().ownerAdminId(Long.valueOf(adminId)).type(StringConverters.trimOrNull((String)type)).status(trimedStatus).exclusiveStatus(trimedStatus == null ? MediaStatus.REMOVED.toString() : CommonConstants.NULL_STRING).allowSearchByLikeOperator(this.settingService.isAllowSearchMediaByLikeOperator()).prefixKeyword(trimmedKeyword).likeKeyword(trimmedKeyword).build(), sortOrder, nextPageToken, prevPageToken, lastPage, limit);
    }

    @Generated
    public AdminApiAdminMeMediaController(AdminAdminService adminService, AdminMediaControllerService mediaControllerService, AdminSettingService settingService, AdminCommonValidator commonValidator, AdminMediaValidator mediaValidator) {
        this.adminService = adminService;
        this.mediaControllerService = mediaControllerService;
        this.settingService = settingService;
        this.commonValidator = commonValidator;
        this.mediaValidator = mediaValidator;
    }
}

