/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import java.util.Set;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminLetterControllerService;
import org.youngmonkeys.ezyplatform.admin.request.ReadLettersRequest;
import org.youngmonkeys.ezyplatform.admin.response.AdminLetterResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminLetterService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.response.CountResponse;

@Api
@Authenticated
@Controller(value="/api/v1")
public class AdminApiLettersController {
    private final AdminLetterService letterService;
    private final AdminLetterControllerService letterControllerService;
    private final AdminCommonValidator commonValidator;

    @DoGet(value="/admins/me/letters/count")
    public CountResponse adminsMeLettersCount(@AdminId long adminId) {
        return new CountResponse(this.letterService.countAdminUnreadLetters(adminId));
    }

    @DoGet(value="/admins/me/letters")
    public PaginationModel<AdminLetterResponse> adminsMeLettersGet(@AdminId long adminId, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="12") int limit) {
        this.commonValidator.validatePageSize(limit);
        return this.letterControllerService.getAdminLetters(adminId, nextPageToken, prevPageToken, lastPage, limit);
    }

    @DoPost(value="/admins/me/letters/{id}/read")
    public ResponseEntity accountMeLettersIdReadPost(@AdminId long adminId, @PathVariable long letterId) {
        this.commonValidator.validateId("letter", letterId);
        this.letterService.updateAdminLetterByRead(adminId, letterId);
        return ResponseEntity.noContent();
    }

    @DoPost(value="/admins/me/letters/read")
    public ResponseEntity accountMeLettersReadPost(@AdminId long adminId, @RequestBody ReadLettersRequest request) {
        this.commonValidator.validateCollectionSize("letterIds", request.getLetterIds());
        this.letterService.updateAdminLettersByRead(adminId, request.getLetterIds());
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/admins/me/letters")
    public ResponseEntity accountMeLettersDelete(@AdminId long adminId, @RequestParam(value="ids") Set<Long> ids) {
        this.commonValidator.validateCollectionSize("letterIds", ids);
        this.letterService.deleteAdminLetters(adminId, ids);
        return ResponseEntity.noContent();
    }

    @Generated
    public AdminApiLettersController(AdminLetterService letterService, AdminLetterControllerService letterControllerService, AdminCommonValidator commonValidator) {
        this.letterService = letterService;
        this.letterControllerService = letterControllerService;
        this.commonValidator = commonValidator;
    }
}

