/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.interceptor;

import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyhttp.core.annotation.Interceptor;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.interceptor.RequestInterceptor;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminActivityHistoryService;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.model.AddAdminActivityHistoryModel;

@Interceptor(priority=0x7FFFFFFF)
public class AdminActivityHistoryInterceptor
implements RequestInterceptor {
    private final RequestURIManager requestUriManager;
    private final FeatureURIManager featureUriManager;
    private final AdminAdminActivityHistoryService adminActivityHistoryService;
    private static final Set<HttpMethod> TRACKED_METHODS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new HttpMethod[]{HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE}));

    public void postHandle(RequestArguments arguments, Method handler) {
        String uriTemplate = arguments.getUriTemplate();
        HttpMethod method = arguments.getMethod();
        if (this.requestUriManager.isManagementURI(method, uriTemplate)) {
            return;
        }
        if (this.requestUriManager.isAuthenticatedURI(method, uriTemplate)) {
            boolean isApiUri = this.requestUriManager.isApiURI(method, uriTemplate);
            if (isApiUri && !TRACKED_METHODS.contains(method)) {
                return;
            }
            long adminId = (Long)arguments.getArgument(AdminId.class);
            String feature = this.featureUriManager.getFeatureByURI(method, uriTemplate);
            this.adminActivityHistoryService.addHistory(AddAdminActivityHistoryModel.builder().adminId(adminId).feature(feature).method(method.name()).uri(arguments.getRequest().getRequestURI()).uriType(isApiUri ? "API" : "VIEW").parameters((Object)arguments.getParameters()).build());
        }
    }

    @Generated
    public AdminActivityHistoryInterceptor(RequestURIManager requestUriManager, FeatureURIManager featureUriManager, AdminAdminActivityHistoryService adminActivityHistoryService) {
        this.requestUriManager = requestUriManager;
        this.featureUriManager = featureUriManager;
        this.adminActivityHistoryService = adminActivityHistoryService;
    }
}

