/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.time.LocalDateTime;
import java.util.Collection;
import org.youngmonkeys.ezyplatform.admin.converter.AdminEntityToModelConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.repo.AdminLetterReceiverRepository;
import org.youngmonkeys.ezyplatform.admin.repo.AdminLetterRepository;
import org.youngmonkeys.ezyplatform.admin.repo.AdminNotificationReceiverRepository;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.Letter;
import org.youngmonkeys.ezyplatform.entity.LetterReceiver;
import org.youngmonkeys.ezyplatform.entity.LetterStatus;
import org.youngmonkeys.ezyplatform.entity.NotificationReceiver;
import org.youngmonkeys.ezyplatform.entity.NotificationStatus;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.model.LetterModel;
import org.youngmonkeys.ezyplatform.repo.LetterReceiverRepository;
import org.youngmonkeys.ezyplatform.repo.LetterRepository;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.service.DefaultLetterService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;

@Service
public class AdminLetterService
extends DefaultLetterService {
    private final ClockProxy clock;
    private final AdminLetterRepository letterRepository;
    private final AdminLetterReceiverRepository letterReceiverRepository;
    private final AdminNotificationReceiverRepository notificationReceiverRepository;
    private final AdminEntityToModelConverter entityToModelConverter;

    public AdminLetterService(ClockProxy clock, AdminLetterRepository letterRepository, AdminLetterReceiverRepository letterReceiverRepository, AdminNotificationReceiverRepository notificationReceiverRepository, AdminEntityToModelConverter entityToModelConverter, AdminModelToEntityConverter modelToEntityConverter) {
        super((LetterRepository)letterRepository, (LetterReceiverRepository)letterReceiverRepository, (DefaultEntityToModelConverter)entityToModelConverter, (DefaultModelToEntityConverter)modelToEntityConverter);
        this.clock = clock;
        this.letterRepository = letterRepository;
        this.letterReceiverRepository = letterReceiverRepository;
        this.notificationReceiverRepository = notificationReceiverRepository;
        this.entityToModelConverter = entityToModelConverter;
    }

    public void updateAdminLetterByReceive(long adminId, long letterId) {
        this.updateAdminLetterByReceive(adminId, letterId, Boolean.TRUE);
    }

    public void updateAdminLetterByReceive(long adminId, long letterId, boolean throwExceptionIfNotExists) {
        LetterReceiver letterReceiver = this.letterReceiverRepository.findByLetterIdAndToAdminId(letterId, adminId);
        if (letterReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("letter");
            }
            return;
        }
        if (letterReceiver.getReceivedAt() == null) {
            letterReceiver.setReceivedAt(this.clock.nowDateTime());
            letterReceiver.setStatus(LetterStatus.RECEIVED.toString());
            this.letterReceiverRepository.save(letterReceiver);
        }
    }

    public void updateAdminLettersByReceive(long adminId, Collection<Long> letterIds) {
        Reactive.multiple().registerConsumers(letterIds, it -> this.updateAdminLetterByRead(adminId, (long)it, Boolean.FALSE)).blockingExecute();
    }

    public void updateAdminLetterByRead(long adminId, long letterId) {
        this.updateAdminLetterByRead(adminId, letterId, Boolean.TRUE);
    }

    public void updateAdminLetterByRead(long adminId, long letterId, boolean throwExceptionIfNotExists) {
        LetterReceiver letterReceiver = this.letterReceiverRepository.findByLetterIdAndToAdminId(letterId, adminId);
        if (letterReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("letter");
            }
            return;
        }
        if (letterReceiver.getReadAt() == null) {
            NotificationReceiver notificationReceiver;
            LocalDateTime now = this.clock.nowDateTime();
            if (letterReceiver.getReceivedAt() == null) {
                letterReceiver.setReceivedAt(now);
            }
            letterReceiver.setReadAt(now);
            letterReceiver.setStatus(LetterStatus.READ.toString());
            this.letterReceiverRepository.save(letterReceiver);
            long notificationReceiverId = letterReceiver.getNotificationReceiverId();
            if (notificationReceiverId > 0L && (notificationReceiver = (NotificationReceiver)this.notificationReceiverRepository.findById(notificationReceiverId)) != null && notificationReceiver.getReadAt() == null) {
                notificationReceiver.setReadAt(now);
                notificationReceiver.setStatus(NotificationStatus.READ.toString());
                this.notificationReceiverRepository.save(notificationReceiver);
            }
        }
    }

    public void updateAdminLettersByRead(long adminId, Collection<Long> letterIds) {
        Reactive.multiple().registerConsumers(letterIds, it -> this.updateAdminLetterByRead(adminId, (long)it, Boolean.FALSE)).blockingExecute();
    }

    public void deleteAdminLetter(long adminId, long letterId) {
        this.deleteAdminLetter(adminId, letterId, Boolean.TRUE);
    }

    public void deleteAdminLetter(long adminId, long letterId, boolean throwExceptionIfNotExists) {
        LetterReceiver letterReceiver = this.letterReceiverRepository.findByLetterIdAndToAdminId(letterId, adminId);
        if (letterReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("letter");
            }
            return;
        }
        this.letterReceiverRepository.delete(letterReceiver.getId());
    }

    public void deleteAdminLetters(long adminId, Collection<Long> letterIds) {
        Reactive.multiple().registerConsumers(letterIds, it -> this.deleteAdminLetter(adminId, (long)it, Boolean.FALSE)).blockingExecute();
    }

    public LetterModel getAdminLetter(long adminId, long letterId) {
        LetterReceiver letterReceiver = this.letterReceiverRepository.findByLetterIdAndToAdminId(letterId, adminId);
        if (letterReceiver == null) {
            return null;
        }
        Letter letter = (Letter)this.letterRepository.findById(letterId);
        if (letter == null) {
            return null;
        }
        return this.entityToModelConverter.toModel(letter, letterReceiver);
    }

    public long countAdminUnreadLetters(long adminId) {
        return this.letterReceiverRepository.countUnreadLettersByToAdminId(adminId);
    }
}

