/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import org.youngmonkeys.ezyplatform.admin.request.UpdatePasswordRequest;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.validator.CommonValidator;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;

@EzySingleton
public class AdminCommonValidator
extends CommonValidator {
    public void validatePageSize(int pageSize) {
        if (!DefaultValidator.isValidPageSize((int)pageSize)) {
            throw new HttpBadRequestException(Collections.singletonMap("pageSize", "invalid"));
        }
    }

    public void validateId(String resourceName, long id) {
        if (id <= 0L) {
            throw new HttpNotFoundException(Collections.singletonMap(resourceName, "notFound"));
        }
    }

    public TargetType validateTarget(String target) {
        HashMap<String, String> errors = new HashMap<String, String>();
        TargetType targetType = TargetType.of((String)target);
        if (targetType == null) {
            errors.put("target", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
        return targetType;
    }

    public void validate(UpdatePasswordRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        String oldPassword = request.getOldPassword();
        if (EzyStrings.isBlank((String)oldPassword)) {
            errors.put("password", "required");
        } else if (!DefaultValidator.isValidPassword((String)oldPassword)) {
            errors.put("password", "invalid");
        }
        String newPassword = request.getNewPassword();
        if (!DefaultValidator.isValidPassword((String)newPassword)) {
            errors.put("newPassword", "invalid");
        } else if (newPassword.equals(oldPassword)) {
            errors.put("newPassword", "must_be_difference_old_password");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }
}

