/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.math;

public final class Numbers {
    private static final int SGN_MASK_FLOAT = Integer.MIN_VALUE;
    private static final int POSITIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(0.0f);
    private static final int NEGATIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(-0.0f);

    private Numbers() {
    }

    public static boolean equals(float x, float y) {
        return x == y || Numbers.equals(x, y, 1);
    }

    public static boolean equals(float x, float y, int maxUlps) {
        boolean isEqual;
        int yInt;
        if (Float.isNaN(x) || Float.isNaN(y)) {
            return false;
        }
        int xInt = Float.floatToRawIntBits(x);
        if (((xInt ^ (yInt = Float.floatToRawIntBits(y))) & Integer.MIN_VALUE) == 0) {
            isEqual = Math.abs(xInt - yInt) <= maxUlps;
        } else {
            int deltaMinus;
            int deltaPlus;
            if (xInt < yInt) {
                deltaPlus = yInt - POSITIVE_ZERO_FLOAT_BITS;
                deltaMinus = xInt - NEGATIVE_ZERO_FLOAT_BITS;
            } else {
                deltaPlus = xInt - POSITIVE_ZERO_FLOAT_BITS;
                deltaMinus = yInt - NEGATIVE_ZERO_FLOAT_BITS;
            }
            isEqual = deltaPlus > maxUlps ? false : deltaMinus <= maxUlps - deltaPlus;
        }
        return isEqual;
    }
}

