/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.util;

import com.tvd12.properties.file.encryption.AesDecrypter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Map<String, Object> toMap(Properties properties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue());
        }
        return map;
    }

    public static Properties toProperties(Map map) {
        Set entries = map.entrySet();
        Properties answer = new Properties();
        for (Map.Entry entry : entries) {
            answer.put(entry.getKey(), entry.getValue());
        }
        return answer;
    }

    public static Properties getPropertiesByPrefix(Map properties, String prefix) {
        Properties answer = new Properties();
        if (prefix.isEmpty()) {
            answer.putAll((Map<?, ?>)properties);
            return answer;
        }
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            if (!keyString.startsWith(prefix)) continue;
            String newKey = "";
            if (keyString.length() > prefix.length() + 1) {
                newKey = keyString.substring(prefix.length() + 1);
            }
            answer.put(newKey, properties.get(key));
        }
        return answer;
    }

    public static Map<String, Properties> getPropertiesMap(Map properties) {
        Set<String> firstKeys = PropertiesUtil.getFirstPropertyKeys(properties);
        HashMap<String, Properties> answer = new HashMap<String, Properties>();
        for (String firstKey : firstKeys) {
            answer.put(firstKey, PropertiesUtil.getPropertiesByPrefix(properties, firstKey));
        }
        return answer;
    }

    public static Set<String> getFirstPropertyKeys(Map properties) {
        return new HashSet<String>(PropertiesUtil.getFirstPropertyKeyList(properties));
    }

    public static List<String> getFirstPropertyKeyList(Map properties) {
        ArrayList<String> answer = new ArrayList<String>();
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            int firstDotIndex = keyString.indexOf(46);
            String firstKey = keyString;
            if (firstDotIndex > 0) {
                firstKey = keyString.substring(0, firstDotIndex);
            }
            if (answer.contains(firstKey)) continue;
            answer.add(firstKey);
        }
        return answer;
    }

    public static boolean containsPrefix(Map properties, String prefix) {
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            if (!keyString.startsWith(prefix) || keyString.length() <= prefix.length()) continue;
            return true;
        }
        return false;
    }

    public static void decorateProperties(Properties properties) {
        HashMap<String, Object> newKeyValues = new HashMap<String, Object>();
        for (Object key : properties.keySet()) {
            String newKey = key.toString().toLowerCase().replace('-', '.').replace('_', '.');
            if (properties.containsKey(newKey)) continue;
            newKeyValues.put(newKey, properties.get(key));
        }
        properties.putAll((Map<?, ?>)newKeyValues);
    }

    public static String getPropertyNameInDotCase(String propertyName) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < propertyName.length(); ++i) {
            char ch = propertyName.charAt(i);
            if (Character.isUpperCase(ch) && i > 0) {
                builder.append(".");
            }
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();
    }

    public static Object getValue(Map<Object, Object> properties, Object key) {
        Object value = properties.get(key);
        if (value == null) {
            String keyInDotCase = PropertiesUtil.getPropertyNameInDotCase(key.toString());
            value = properties.get(keyInDotCase);
            if (value == null && (value = System.getProperty(key.toString())) == null) {
                value = System.getProperty(keyInDotCase);
            }
            if (value == null && (value = System.getenv(key.toString())) == null) {
                value = System.getenv(keyInDotCase);
            }
        }
        return value;
    }

    public static Object defaultValueOf(Class<?> type) {
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        return null;
    }

    public static Properties filterPropertiesByKeyPrefix(Properties properties, String keyPrefix) {
        return PropertiesUtil.filterProperties(properties, it -> it.startsWith(keyPrefix));
    }

    public static Properties filterProperties(Properties properties, Predicate<String> filter) {
        Properties answer = new Properties();
        for (Object key : properties.keySet()) {
            if (!filter.test(key.toString())) continue;
            answer.put(key, properties.get(key));
        }
        return answer;
    }

    public static void setVariableValues(Map<Object, Object> properties) {
        PropertiesUtil.decryptPropertiesValues(properties);
        PropertiesUtil.doSetVariableValues(properties);
    }

    public static void decryptPropertiesValues(Map<Object, Object> properties) {
        Object decryptionKey = PropertiesUtil.getValue(properties, "properties.decryption_key");
        if (decryptionKey == null) {
            return;
        }
        String decryptionKeyString = decryptionKey.toString();
        ArrayList<Object> keys = new ArrayList<Object>(properties.keySet());
        for (Object e : keys) {
            Object value = properties.get(e);
            if (!(value instanceof String)) continue;
            String decryptedValue = AesDecrypter.getInstance().decryptOrIgnore((String)value, decryptionKeyString);
            properties.put(e, decryptedValue);
        }
    }

    private static void doSetVariableValues(Map<Object, Object> properties) {
        ArrayList<Object> keys = new ArrayList<Object>(properties.keySet());
        for (Object e : keys) {
            Object value = properties.get(e);
            if (!(value instanceof String)) continue;
            String valueString = (String)value;
            Set<String> keyStrings = PropertiesUtil.getKeysFromVariableName(valueString.trim());
            for (String keyString : keyStrings) {
                Object variableValue = properties.get(keyString);
                if (variableValue == null) {
                    variableValue = PropertiesUtil.getSystemVariableValue(keyString);
                }
                if (variableValue == null) continue;
                valueString = valueString.replace("${" + keyString + "}", variableValue.toString());
            }
            properties.put(e, valueString);
        }
    }

    public static String getKeyFromVariableName(String variableName) {
        if (variableName.startsWith("${") && variableName.endsWith("}") && variableName.length() > 3) {
            return variableName.substring(2, variableName.length() - 1).trim();
        }
        return null;
    }

    public static Set<String> getKeysFromVariableName(String variableName) {
        HashSet<String> keys = new HashSet<String>();
        StringBuilder keyBuilder = null;
        for (int i = 0; i < variableName.length(); ++i) {
            char ch0 = variableName.charAt(i);
            if (keyBuilder != null) {
                if (ch0 == '}') {
                    if (keyBuilder.length() > 0) {
                        keys.add(keyBuilder.toString());
                    }
                    keyBuilder = null;
                    continue;
                }
                keyBuilder.append(ch0);
                continue;
            }
            if (i >= variableName.length() - 1) continue;
            char ch1 = variableName.charAt(i + 1);
            if (ch0 != '$' || ch1 != '{') continue;
            keyBuilder = new StringBuilder();
            ++i;
        }
        return keys;
    }

    public static String getSystemVariableValue(String variableName) {
        String value = System.getProperty(variableName);
        if (value == null) {
            value = System.getenv(variableName);
        }
        return value;
    }
}

