/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.codec.EzyMessageHeader;
import com.tvd12.ezyfox.codec.EzyMessageHeaderReader;
import com.tvd12.ezyfox.codec.EzySimpleMessage;
import com.tvd12.ezyfox.exception.EzyMaxRequestSizeException;
import com.tvd12.ezyfox.exception.EzyZeroRequestSizeException;

public abstract class EzyMessageReader<B> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected int size;
    protected byte[] content;
    protected byte headerByte;
    protected byte[] sizeBytes;
    protected EzyMessageHeader header;

    public EzyMessageReader() {
        this.clear();
    }

    protected abstract int remaining(B var1);

    protected abstract byte readByte(B var1);

    protected abstract int readMessageSize(B var1);

    protected abstract void readMessageContent(B var1, byte[] var2, int var3, int var4);

    public boolean readHeader(B buffer) {
        int remaining = this.remaining(buffer);
        if (remaining < this.getHeaderLength()) {
            return false;
        }
        this.headerByte = this.readByte(buffer);
        this.readHeader(this.headerByte);
        return true;
    }

    private void readHeader(byte header) {
        this.header = EzyMessageHeaderReader.read(header);
    }

    public boolean readSize(B buffer, int maxSize) {
        int remaining = this.remaining(buffer);
        if (remaining < this.getSizeLength()) {
            return false;
        }
        this.size = this.readMessageSize(buffer);
        if (this.size <= 0) {
            throw new EzyZeroRequestSizeException();
        }
        if (this.size > maxSize) {
            throw new EzyMaxRequestSizeException(this.size, maxSize);
        }
        return true;
    }

    public boolean readContent(B buffer) {
        int remaining = this.remaining(buffer);
        if (remaining < this.size) {
            return false;
        }
        boolean rawBytes = this.isRawBytes();
        if (rawBytes) {
            int offset = this.getHeaderLength() + this.sizeBytes.length;
            int rawSize = this.size + offset;
            this.content = new byte[rawSize];
            this.content[0] = this.headerByte;
            System.arraycopy(this.sizeBytes, 0, this.content, 1, this.sizeBytes.length);
            this.readMessageContent(buffer, this.content, offset, this.size);
        } else {
            this.content = new byte[this.size];
            this.readMessageContent(buffer, this.content, 0, this.size);
        }
        return true;
    }

    public void clear() {
        this.size = 0;
        this.headerByte = 0;
        this.sizeBytes = EMPTY_BYTE_ARRAY;
        this.content = EMPTY_BYTE_ARRAY;
    }

    public EzyMessage get() {
        return new EzySimpleMessage(this.header, this.content, this.size);
    }

    protected int getSizeLength() {
        return this.header.isBigSize() ? 4 : 2;
    }

    protected boolean isRawBytes() {
        return this.header.isRawBytes();
    }

    protected int getHeaderLength() {
        return 1;
    }
}

