/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.config;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.youngmonkeys.ezyplatform.config.AbstractMessageProvider;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.web.manager.WebFileSystemManager;
import org.youngmonkeys.ezyplatform.web.settings.ModuleMetadata;
import org.youngmonkeys.ezyplatform.web.settings.WebModuleMetadataReader;

@EzySingleton
public class WebMessageProvider
extends AbstractMessageProvider {
    private final WebFileSystemManager fileSystemManager;

    public WebMessageProvider(WebFileSystemManager fileSystemManager) {
        super((FileSystemManager)fileSystemManager);
        this.fileSystemManager = fileSystemManager;
    }

    protected TargetType getInclusiveTargetType() {
        return TargetType.WEB;
    }

    protected ModuleType[] getInclusiveModuleTypes() {
        return new ModuleType[]{ModuleType.THEME, ModuleType.WEB_PLUGIN};
    }

    protected Map<ModuleType, List<String>> getInclusiveModulesMapByModuleTypes(ModuleType[] moduleTypes) {
        String ezyplatformHome = this.fileSystemManager.getEzyHomePathString();
        Map<ModuleType, Map<String, ModuleMetadata>> moduleMetadataMapByModuleType = new WebModuleMetadataReader().read(ezyplatformHome);
        HashMap<ModuleType, List<String>> answer = new HashMap<ModuleType, List<String>>();
        for (ModuleType moduleType : moduleTypes) {
            Map<String, ModuleMetadata> moduleMetadataMap = moduleMetadataMapByModuleType.get(moduleType);
            for (String module : moduleMetadataMap.keySet()) {
                ModuleMetadata moduleMetadata = moduleMetadataMap.get(module);
                if (!moduleMetadata.isActive()) continue;
                answer.computeIfAbsent(moduleType, k -> new ArrayList()).add(module);
            }
        }
        return answer;
    }
}

