/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.config;

import com.tvd12.ezyfox.bean.EzyPackagesToScanProvider;
import com.tvd12.ezyfox.io.EzySets;
import com.tvd12.ezyfox.io.EzyStrings;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.web.settings.ModuleMetadata;
import org.youngmonkeys.ezyplatform.web.settings.ModuleProperties;
import org.youngmonkeys.ezyplatform.web.settings.WebModuleMetadataReader;
import org.youngmonkeys.ezyplatform.web.settings.WebModulePropertiesReader;

public class WebPackagesToScanProvider
implements EzyPackagesToScanProvider {
    private final WebModulePropertiesReader modulePropertiesReader = new WebModulePropertiesReader();
    private static final String FOLDER_PLUGINS = "web/plugins";
    private static final String FOLDER_THEMES = "web/themes";

    public Set<String> provide() {
        File welcomeThemeFolder;
        String ezyplatformHome = FileSystemManager.readConfigAndGetEzyHomePathString();
        Map<ModuleType, Map<String, ModuleMetadata>> moduleMetadataMapByModuleType = new WebModuleMetadataReader().read(ezyplatformHome);
        HashSet<String> answer = new HashSet<String>(this.getModulePackages(ezyplatformHome, FOLDER_PLUGINS, moduleMetadataMapByModuleType.get(ModuleType.WEB_PLUGIN)));
        Set<String> themePackages = this.getModulePackages(ezyplatformHome, FOLDER_THEMES, moduleMetadataMapByModuleType.get(ModuleType.THEME));
        if (themePackages.isEmpty() && (welcomeThemeFolder = this.getWelcomeThemeFolder(ezyplatformHome)).exists()) {
            ModuleProperties moduleProperties = this.modulePropertiesReader.read(welcomeThemeFolder);
            themePackages.add(moduleProperties.getPackageName());
        }
        answer.addAll(themePackages);
        return answer;
    }

    private Set<String> getModulePackages(String ezyplatformHome, String containerFolder, Map<String, ModuleMetadata> moduleMetadataMap) {
        HashSet<String> answer = new HashSet<String>();
        List pluginFolders = FileSystemManager.getModuleFolders((String)ezyplatformHome, (String)containerFolder);
        for (File pluginFolder : pluginFolders) {
            ModuleMetadata moduleMetadata = moduleMetadataMap.get(pluginFolder.getName());
            if (moduleMetadata == null || !moduleMetadata.isActive()) continue;
            ModuleProperties moduleProperties = this.modulePropertiesReader.read(pluginFolder);
            answer.add(moduleProperties.getPackageName());
        }
        return EzySets.filter(answer, EzyStrings::isNotBlank);
    }

    private File getWelcomeThemeFolder(String ezyplatformHome) {
        return Paths.get(FileSystemManager.concatWithEzyHome((String)ezyplatformHome, (String)FOLDER_THEMES).toString(), "welcome").toFile();
    }
}

