/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyAbstractToBytesSerializer;
import com.tvd12.ezyfox.codec.MsgPackArraySizeSerializer;
import com.tvd12.ezyfox.codec.MsgPackBinSizeSerializer;
import com.tvd12.ezyfox.codec.MsgPackDoubleSerializer;
import com.tvd12.ezyfox.codec.MsgPackFloatSerializer;
import com.tvd12.ezyfox.codec.MsgPackIntSerializer;
import com.tvd12.ezyfox.codec.MsgPackMapSizeSerializer;
import com.tvd12.ezyfox.codec.MsgPackStringSizeSerializer;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyArrayList;
import com.tvd12.ezyfox.entity.EzyHashMap;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.function.EzyParser;
import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfox.io.EzyCastToByte;
import com.tvd12.ezyfox.io.EzyDataConverter;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyBoolsIterator;
import com.tvd12.ezyfox.util.EzyDoublesIterator;
import com.tvd12.ezyfox.util.EzyFloatsIterator;
import com.tvd12.ezyfox.util.EzyIntsIterator;
import com.tvd12.ezyfox.util.EzyLongsIterator;
import com.tvd12.ezyfox.util.EzyShortsIterator;
import com.tvd12.ezyfox.util.EzyStringsIterator;
import com.tvd12.ezyfox.util.EzyWrapperIterator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class MsgPackSimpleSerializer
extends EzyAbstractToBytesSerializer
implements EzyCastToByte {
    protected final MsgPackIntSerializer intSerializer = MsgPackIntSerializer.getInstance();
    protected final MsgPackFloatSerializer floatSerializer = MsgPackFloatSerializer.getInstance();
    protected final MsgPackDoubleSerializer doubleSerializer = MsgPackDoubleSerializer.getInstance();
    protected final MsgPackBinSizeSerializer binSizeSerializer = MsgPackBinSizeSerializer.getInstance();
    protected final MsgPackMapSizeSerializer mapSizeSerializer = MsgPackMapSizeSerializer.getInstance();
    protected final MsgPackArraySizeSerializer arraySizeSerializer = MsgPackArraySizeSerializer.getInstance();
    protected final MsgPackStringSizeSerializer stringSizeSerializer = MsgPackStringSizeSerializer.getInstance();

    protected void addParsers(Map<Class<?>, EzyParser<Object, byte[]>> parsers) {
        parsers.put(Boolean.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseBoolean));
        parsers.put(Byte.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseByte));
        parsers.put(Character.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseChar));
        parsers.put(Double.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseDouble));
        parsers.put(Float.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseFloat));
        parsers.put(Integer.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseInt));
        parsers.put(Long.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseInt));
        parsers.put(Short.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseShort));
        parsers.put(String.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseString));
        parsers.put(boolean[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parsePrimitiveBooleans));
        parsers.put(byte[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseBin));
        parsers.put(char[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parsePrimitiveChars));
        parsers.put(double[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parsePrimitiveDoubles));
        parsers.put(float[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parsePrimitiveFloats));
        parsers.put(int[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parsePrimitiveInts));
        parsers.put(long[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parsePrimitiveLongs));
        parsers.put(short[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parsePrimitiveShorts));
        parsers.put(String[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseStrings));
        parsers.put(Byte[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseWrapperBytes));
        parsers.put(Boolean[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseWrapperBooleans));
        parsers.put(Character[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseWrapperChars));
        parsers.put(Double[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseWrapperDoubles));
        parsers.put(Float[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseWrapperFloats));
        parsers.put(Integer[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseWrapperInts));
        parsers.put(Long[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseWrapperLongs));
        parsers.put(Short[].class, (EzyParser<Object, byte[]>)((EzyParser)this::parseWrapperShorts));
        parsers.put(Map.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseMap));
        parsers.put(AbstractMap.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseMap));
        parsers.put(HashMap.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseMap));
        parsers.put(EzyObject.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseObject));
        parsers.put(EzyHashMap.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseObject));
        parsers.put(EzyArray.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseArray));
        parsers.put(EzyArrayList.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseArray));
        parsers.put(Collection.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseCollection));
        parsers.put(AbstractCollection.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseCollection));
        parsers.put(Set.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseCollection));
        parsers.put(AbstractSet.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseCollection));
        parsers.put(List.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseCollection));
        parsers.put(AbstractList.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseCollection));
        parsers.put(HashSet.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseCollection));
        parsers.put(ArrayList.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseCollection));
        parsers.put(BigInteger.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseValueToString));
        parsers.put(BigDecimal.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseBigDecimalToString));
        parsers.put(UUID.class, (EzyParser<Object, byte[]>)((EzyParser)this::parseValueToString));
    }

    protected byte[] parsePrimitiveBooleans(Object array) {
        return this.parseBooleans((boolean[])array);
    }

    protected byte[] parseBooleans(boolean[] array) {
        return this.parseArray((Iterator)EzyBoolsIterator.wrap((boolean[])array), array.length);
    }

    protected byte[] parsePrimitiveChars(Object array) {
        return this.parseChars((char[])array);
    }

    protected byte[] parseChars(char[] array) {
        return this.parseBin(EzyDataConverter.charArrayToByteArray((char[])array));
    }

    protected byte[] parsePrimitiveDoubles(Object array) {
        return this.parseDoubles((double[])array);
    }

    protected byte[] parseDoubles(double[] array) {
        return this.parseArray((Iterator)EzyDoublesIterator.wrap((double[])array), array.length);
    }

    protected byte[] parsePrimitiveFloats(Object array) {
        return this.parseFloats((float[])array);
    }

    protected byte[] parseFloats(float[] array) {
        return this.parseArray((Iterator)EzyFloatsIterator.wrap((float[])array), array.length);
    }

    protected byte[] parsePrimitiveInts(Object array) {
        return this.parseInts((int[])array);
    }

    protected byte[] parseInts(int[] array) {
        return this.parseArray((Iterator)EzyIntsIterator.wrap((int[])array), array.length);
    }

    protected byte[] parsePrimitiveLongs(Object array) {
        return this.parseLongs((long[])array);
    }

    protected byte[] parseLongs(long[] array) {
        return this.parseArray((Iterator)EzyLongsIterator.wrap((long[])array), array.length);
    }

    protected byte[] parsePrimitiveShorts(Object array) {
        return this.parseShorts((short[])array);
    }

    protected byte[] parseShorts(short[] array) {
        return this.parseArray((Iterator)EzyShortsIterator.wrap((short[])array), array.length);
    }

    protected byte[] parseStrings(Object array) {
        return this.parseStrings((String[])array);
    }

    protected byte[] parseStrings(String[] array) {
        return this.parseArray((Iterator)EzyStringsIterator.wrap((String[])array), array.length);
    }

    protected byte[] parseWrapperBooleans(Object array) {
        return this.parseBooleans((Boolean[])array);
    }

    protected byte[] parseBooleans(Boolean[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected byte[] parseWrapperBytes(Object array) {
        return this.parseBytes((Byte[])array);
    }

    protected byte[] parseBytes(Byte[] array) {
        return this.parseBin(EzyDataConverter.toPrimitiveByteArray((Byte[])array));
    }

    protected byte[] parseWrapperChars(Object array) {
        return this.parseChars((Character[])array);
    }

    protected byte[] parseChars(Character[] array) {
        return this.parseBin(EzyDataConverter.charWrapperArrayToPrimitiveByteArray((Character[])array));
    }

    protected byte[] parseWrapperDoubles(Object array) {
        return this.parseDoubles((Double[])array);
    }

    protected byte[] parseDoubles(Double[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected byte[] parseWrapperFloats(Object array) {
        return this.parseFloats((Float[])array);
    }

    protected byte[] parseFloats(Float[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected byte[] parseWrapperInts(Object array) {
        return this.parseInts((Integer[])array);
    }

    protected byte[] parseInts(Integer[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected byte[] parseWrapperLongs(Object array) {
        return this.parseLongs((Long[])array);
    }

    protected byte[] parseLongs(Long[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected byte[] parseWrapperShorts(Object array) {
        return this.parseShorts((Short[])array);
    }

    protected byte[] parseShorts(Short[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected byte[] parseBoolean(Object value) {
        return this.parseBoolean((Boolean)value);
    }

    protected byte[] parseBoolean(Boolean value) {
        return value != false ? this.parseTrue() : this.parseFalse();
    }

    protected byte[] parseFalse() {
        return new byte[]{this.cast(194)};
    }

    protected byte[] parseTrue() {
        return new byte[]{this.cast(195)};
    }

    protected byte[] parseByte(Object value) {
        return this.parseByte((Byte)value);
    }

    protected byte[] parseByte(Byte value) {
        return this.parseInt(value.intValue());
    }

    protected byte[] parseChar(Object value) {
        return this.parseChar((Character)value);
    }

    protected byte[] parseChar(Character value) {
        return this.parseByte((byte)value.charValue());
    }

    protected byte[] parseDouble(Object value) {
        return this.parseDouble((Double)value);
    }

    protected byte[] parseDouble(Double value) {
        return this.doubleSerializer.serialize(value);
    }

    protected byte[] parseFloat(Object value) {
        return this.parseFloat((Float)value);
    }

    protected byte[] parseFloat(Float value) {
        return this.floatSerializer.serialize(value.floatValue());
    }

    protected byte[] parseInt(Object value) {
        return this.intSerializer.serialize(((Number)value).longValue());
    }

    protected byte[] parseShort(Object value) {
        return this.parseShort((Short)value);
    }

    protected byte[] parseShort(Short value) {
        return this.parseInt(value.intValue());
    }

    protected byte[] parseString(Object string) {
        return this.parseString((String)string);
    }

    protected byte[] parseMap(Object map) {
        return this.parseMap((Map)map);
    }

    protected byte[] parseMap(Map map) {
        return this.parseEntries(map.entrySet());
    }

    protected byte[] parseObject(Object obj) {
        return this.parseEntries(((EzyObject)obj).entrySet());
    }

    protected byte[] parseCollection(Object coll) {
        return this.parseCollection((Collection)coll);
    }

    protected byte[] parseArray(Object array) {
        return this.parseArray((EzyArray)array);
    }

    protected byte[] parseCollection(Collection coll) {
        return this.parseIterable(coll, coll.size());
    }

    protected byte[] parseArray(EzyArray array) {
        return this.parseArray(array.iterator(), array.size());
    }

    protected byte[] parseNil() {
        return new byte[]{this.cast(192)};
    }

    protected byte[] parseBin(Object bin) {
        return this.parseBin((byte[])bin);
    }

    protected byte[] parseBin(byte[] bin) {
        byte[][] byteArrays = new byte[][]{this.parseBinSize(bin.length), bin};
        return EzyBytes.merge((byte[][])byteArrays);
    }

    protected byte[] parseBinSize(int size) {
        return this.binSizeSerializer.serialize(size);
    }

    protected byte[] parseString(String string) {
        byte[][] byteArrays = new byte[2][];
        byteArrays[1] = EzyStrings.getUtfBytes((String)string);
        byteArrays[0] = this.parseStringSize(byteArrays[1].length);
        return EzyBytes.merge((byte[][])byteArrays);
    }

    protected byte[] parseStringSize(int size) {
        return this.stringSizeSerializer.serialize(size);
    }

    protected byte[] parseIterable(Iterable iterable, int size) {
        return this.parseArray(iterable.iterator(), size);
    }

    protected byte[] parseArray(Iterator iterator, int size) {
        int index = 1;
        byte[][] byteArrays = new byte[size + 1][];
        byteArrays[0] = this.parseArraySize(size);
        while (iterator.hasNext()) {
            byteArrays[index++] = this.serialize(iterator.next());
        }
        return EzyBytes.merge((byte[][])byteArrays);
    }

    protected byte[] parseArraySize(int size) {
        return this.arraySizeSerializer.serialize(size);
    }

    protected byte[] parseEntries(Set<Map.Entry<Object, Object>> entries) {
        int index = 1;
        int size = entries.size();
        byte[][] byteArrays = new byte[size * 2 + 1][];
        byteArrays[0] = this.parseMapSize(size);
        for (Map.Entry<Object, Object> e : entries) {
            byteArrays[index++] = this.serialize(e.getKey());
            byteArrays[index++] = this.serialize(e.getValue());
        }
        return EzyBytes.merge((byte[][])byteArrays);
    }

    protected byte[] parseMapSize(int size) {
        return this.mapSizeSerializer.serialize(size);
    }

    protected byte[] parseBigDecimalToString(Object value) {
        return this.parseString(((BigDecimal)value).toPlainString());
    }

    protected byte[] parseValueToString(Object value) {
        return this.parseString(value.toString());
    }
}

