/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.impl;

import com.tvd12.ezyfox.binding.annotation.EzyIgnore;
import com.tvd12.ezyfox.binding.impl.EzyElementsFetcher;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class EzyAbstractElementsFetcher
extends EzyLoggable
implements EzyElementsFetcher {
    protected List<? extends EzyMethod> methodList;
    protected List<? extends EzyMethod> unoverriddenMethodList;
    protected Map<String, ? extends EzyMethod> methodsByFieldName;

    @Override
    public final List<Object> getElements(EzyClass clazz, int accessType) {
        this.logger.debug("start scan {}", (Object)clazz);
        this.init(clazz);
        List<Object> elements = this.doGetElements(clazz, accessType);
        this.logger.debug("finish scan {}", (Object)clazz);
        return elements;
    }

    protected final void init(EzyClass clazz) {
        this.methodList = this.getMethodList(clazz);
        this.unoverriddenMethodList = this.filterOverriddenMethods(this.methodList);
        this.methodsByFieldName = this.mapMethodsByFieldName(this.unoverriddenMethodList);
    }

    protected abstract List<Object> doGetElements(EzyClass var1, int var2);

    protected final List<EzyField> getFields(EzyClass clazz, int accessType) {
        ArrayList fields = new ArrayList();
        if ((accessType & 1) > 0) {
            fields.addAll(clazz.getFields());
        } else if ((accessType & 4) > 0) {
            fields.addAll(clazz.getDeclaredFields());
        }
        return EzyLists.filter(fields, f -> !f.isAnnotated(EzyIgnore.class));
    }

    protected final List<? extends EzyMethod> getMethods(EzyClass clazz, int accessType) {
        ArrayList<Object> methods = new ArrayList<Object>();
        if ((accessType & 2) > 0) {
            methods.addAll(this.unoverriddenMethodList);
        } else if ((accessType & 8) > 0) {
            methods.addAll(this.getDeclaredMethods(clazz));
        }
        return EzyLists.filter(methods, m -> !this.isIgnoredMethod((EzyMethod)m, clazz));
    }

    protected final List<? extends EzyMethod> getAnnotatedMethods(EzyClass clazz) {
        List methods0 = EzyLists.filter((Collection)clazz.getMethods(), this::shouldAddAnnotatedMethod);
        List<? extends EzyMethod> methods = this.filterOverriddenMethods(methods0);
        return EzyLists.newArrayList(methods, this::newByFieldMethod);
    }

    protected abstract boolean shouldAddAnnotatedMethod(EzyMethod var1);

    protected abstract EzyMethod newByFieldMethod(EzyMethod var1);

    protected final List<? extends EzyMethod> filterOverriddenMethods(Collection allMethods) {
        return EzyMethods.filterOverriddenMethods((Collection)allMethods);
    }

    protected boolean isValidGenericField(EzyField field) {
        return true;
    }

    protected boolean isValidGenericMethod(EzyMethod method) {
        return true;
    }

    protected abstract List<? extends EzyMethod> getMethodList(EzyClass var1);

    protected abstract List<? extends EzyMethod> getDeclaredMethods(EzyClass var1);

    private Map<String, ? extends EzyMethod> mapMethodsByFieldName(List<? extends EzyMethod> methods) {
        return EzyMaps.newHashMap(methods, EzyMethod::getFieldName);
    }

    private boolean isIgnoredMethod(EzyMethod method, EzyClass clazz) {
        boolean ignored = method.isAnnotated(EzyIgnore.class);
        if (ignored) {
            return true;
        }
        String fieldName = method.getFieldName();
        EzyField field = clazz.getField(fieldName);
        return field != null && field.isAnnotated(EzyIgnore.class);
    }
}

