/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.impl;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.binding.EzyMarshaller;
import com.tvd12.ezyfox.binding.EzyWriter;
import com.tvd12.ezyfox.binding.exception.EzyWriteValueException;
import com.tvd12.ezyfox.binding.impl.EzyAbstractBuilder;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyGetterMethod;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;

public abstract class EzyAbstractWriterBuilder
extends EzyAbstractBuilder<EzyGetterMethod>
implements EzyBuilder<EzyWriter> {
    protected EzyAbstractWriterBuilder(EzyClass clazz) {
        super(clazz);
    }

    public EzyWriter build() {
        try {
            return this.make();
        }
        catch (Exception e) {
            throw new IllegalStateException("can not build writer for class " + this.clazz, e);
        }
    }

    protected EzyWriter make() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        String implClassName = this.getImplClassName();
        CtClass implClass = pool.makeClass(implClassName);
        EzyMethod writeMethod = this.getWriteMethod();
        writeMethod.setDisplayName("write$impl");
        String implMethodContent = this.makeImplMethodContent(writeMethod);
        writeMethod.setDisplayName("write");
        String methodContent = this.makeMethodContent(writeMethod);
        this.printMethodContent(methodContent);
        this.printMethodContent(implMethodContent);
        implClass.setInterfaces(new CtClass[]{pool.makeClass(EzyWriter.class.getName())});
        implClass.addMethod(CtNewMethod.make((String)implMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)methodContent, (CtClass)implClass));
        Class answerClass = implClass.toClass();
        implClass.detach();
        this.logger.debug("class {} has generated", (Object)implClassName);
        return (EzyWriter)EzyClasses.newInstance((Class)answerClass);
    }

    protected String makeMethodContent(EzyMethod writeMethod) {
        return new EzyFunction(writeMethod).body().append(new EzyInstruction("\t", "\n", false).append("try {")).append(new EzyInstruction("\t\t", "\n").append("return this.write$impl(arg0, arg1)")).append(new EzyInstruction("\t", "\n", false).append("} catch(").clazz(Exception.class).append(" e) {")).append(new EzyInstruction("\t\t", "\n\t}\n").append("throw new ").clazz(EzyWriteValueException.class).bracketopen().clazz(this.getOutType(), true).append(", arg1, e").bracketclose()).function().toString();
    }

    protected abstract Class<?> getOutType();

    protected abstract String getImplClassName();

    protected abstract String makeImplMethodContent(EzyMethod var1);

    protected com.tvd12.ezyfox.binding.annotation.EzyWriter getWriterClass(EzyReflectElement element) {
        com.tvd12.ezyfox.binding.annotation.EzyWriter wrt = this.getWriterAnnotation(element);
        if (wrt != null) {
            return wrt;
        }
        if (element instanceof EzyField) {
            return null;
        }
        EzyField field = this.clazz.getField(this.getFieldName(element));
        return field == null ? null : this.getWriterAnnotation((EzyReflectElement)field);
    }

    protected com.tvd12.ezyfox.binding.annotation.EzyWriter getWriterAnnotation(EzyReflectElement element) {
        return (com.tvd12.ezyfox.binding.annotation.EzyWriter)element.getAnnotation(com.tvd12.ezyfox.binding.annotation.EzyWriter.class);
    }

    protected EzyMethod getWriteMethod() {
        return EzyMethod.builder().clazz(EzyWriter.class).methodName("write").parameterTypes(new Class[]{EzyMarshaller.class}).parameterTypes(new Class[]{Object.class}).build();
    }

    protected void printMethodContent(String methodContent) {
        if (this.isDebug()) {
            this.logger.debug("writer: method content \n{}", (Object)methodContent);
        }
    }

    protected abstract boolean isDebug();
}

