/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.reader;

import com.tvd12.ezyfox.binding.EzyReader;
import com.tvd12.ezyfox.binding.EzyUnmarshaller;
import com.tvd12.ezyfox.entity.EzyArray;
import java.util.Collection;

public abstract class EzyPrimitiveArrayReader
implements EzyReader<Object, Object> {
    @Override
    public Object read(EzyUnmarshaller unmarshaller, Object value) {
        if (value instanceof EzyArray) {
            return this.readArray(unmarshaller, (EzyArray)value);
        }
        if (value instanceof Collection) {
            return this.readCollection(unmarshaller, (Collection)value);
        }
        return value;
    }

    protected Object readArray(EzyUnmarshaller unmarshaller, EzyArray array) {
        int length = array.size();
        Class<?> outType = this.getOutType();
        Object answer = this.newArray(length);
        for (int i = 0; i < length; ++i) {
            Object value = unmarshaller.unmarshal(array.get(i), outType);
            this.setValue(answer, i, value);
        }
        return answer;
    }

    protected Object readCollection(EzyUnmarshaller unmarshaller, Collection collection) {
        int length = collection.size();
        Class<?> outType = this.getOutType();
        Object answer = this.newArray(length);
        int index = 0;
        for (Object item : collection) {
            Object value = unmarshaller.unmarshal(item, outType);
            this.setValue(answer, index++, value);
        }
        return answer;
    }

    protected abstract void setValue(Object var1, int var2, Object var3);

    protected abstract Class<?> getOutType();

    protected abstract Object newArray(int var1);
}

