/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.handler;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.constant.EzyCommand;
import com.tvd12.ezyfoxserver.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.constant.EzyTransportType;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.entity.EzyAbstractSession;
import com.tvd12.ezyfoxserver.entity.EzyDroppedPackets;
import com.tvd12.ezyfoxserver.entity.EzyImmediateDeliver;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.nio.entity.EzyNioSession;
import com.tvd12.ezyfoxserver.nio.handler.EzyHandlerGroup;
import com.tvd12.ezyfoxserver.nio.handler.EzyNioDataHandler;
import com.tvd12.ezyfoxserver.nio.handler.EzySimpleNioDataHandler;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import com.tvd12.ezyfoxserver.socket.EzyDatagramChannelPool;
import com.tvd12.ezyfoxserver.socket.EzyPacket;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsQueue;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsRequestQueues;
import com.tvd12.ezyfoxserver.socket.EzySimpleSocketRequest;
import com.tvd12.ezyfoxserver.socket.EzySocketDisconnectionQueue;
import com.tvd12.ezyfoxserver.socket.EzySocketRequest;
import com.tvd12.ezyfoxserver.socket.EzySocketStreamQueue;
import com.tvd12.ezyfoxserver.statistics.EzyNetworkStats;
import com.tvd12.ezyfoxserver.statistics.EzySessionStats;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public abstract class EzyAbstractHandlerGroup<D extends EzyDestroyable>
extends EzyLoggable
implements EzyImmediateDeliver,
EzyDroppedPackets,
EzyDestroyable {
    protected final EzyChannel channel;
    protected final D decoder;
    protected final EzyNioDataHandler handler;
    protected final boolean streamingEnable;
    protected final AtomicInteger sessionCount;
    protected final EzySessionStats sessionStats;
    protected final EzyNetworkStats networkStats;
    protected final ExecutorService statsThreadPool;
    protected final EzyNioSession session;
    protected final EzySocketStreamQueue streamQueue;
    protected final EzySessionTicketsQueue sessionTicketsQueue;
    protected final EzySocketDisconnectionQueue disconnectionQueue;
    protected final EzySessionTicketsRequestQueues sessionTicketsRequestQueues;

    public EzyAbstractHandlerGroup(Builder builder) {
        this.session = builder.session;
        this.sessionCount = builder.sessionCount;
        this.sessionStats = builder.sessionStats;
        this.networkStats = builder.networkStats;
        this.statsThreadPool = builder.statsThreadPool;
        this.streamQueue = builder.streamQueue;
        this.streamingEnable = builder.isStreamingEnable();
        this.disconnectionQueue = builder.disconnectionQueue;
        this.sessionTicketsQueue = builder.sessionTicketsQueue;
        this.sessionTicketsRequestQueues = builder.sessionTicketsRequestQueues;
        this.channel = this.session.getChannel();
        this.decoder = this.newDecoder(builder.decoder);
        this.handler = this.newDataHandler(builder);
        ((EzyAbstractSession)this.session).setDisconnectionQueue(this.disconnectionQueue);
        ((EzyAbstractSession)this.session).setSessionTicketsQueue(this.sessionTicketsQueue);
        ((EzyAbstractSession)this.session).setDroppedPackets((EzyDroppedPackets)this);
        ((EzyAbstractSession)this.session).setImmediateDeliver((EzyImmediateDeliver)this);
        this.sessionStats.addSessions(1);
        this.sessionStats.setCurrentSessions(this.sessionCount.incrementAndGet());
    }

    protected abstract D newDecoder(Object var1);

    private EzyNioDataHandler newDataHandler(Builder builder) {
        return new EzySimpleNioDataHandler(builder.serverContext, builder.session);
    }

    public final void enqueueDisconnection(EzyConstant reason) {
        this.session.disconnect(reason);
    }

    public final void fireChannelInactive() {
        this.fireChannelInactive((EzyConstant)EzyDisconnectReason.UNKNOWN);
    }

    public final void fireChannelInactive(EzyConstant reason) {
        try {
            this.handler.channelInactive(reason);
        }
        catch (Throwable e) {
            this.logger.error("handler inactive error", e);
        }
        finally {
            this.sessionStats.setCurrentSessions(this.sessionCount.decrementAndGet());
        }
    }

    public final void fireExceptionCaught(Throwable throwable) {
        try {
            this.handler.exceptionCaught(throwable);
        }
        catch (Exception e) {
            this.fireChannelInactive((EzyConstant)EzyDisconnectReason.SERVER_ERROR);
        }
    }

    public final void firePacketSend(EzyPacket packet, Object writeBuffer) {
        this.executeSendingPacket(packet, writeBuffer);
    }

    public final void fireChannelRead(EzyCommand cmd, EzyArray msg) throws Exception {
        this.handler.channelRead(cmd, msg);
    }

    public void fireStreamBytesReceived(byte[] bytes) throws Exception {
        this.handler.streamingReceived(bytes);
    }

    public final void sendPacketNow(EzyPacket packet) {
        try {
            this.doSendPacketNow(packet);
        }
        finally {
            packet.release();
        }
    }

    protected void doSendPacketNow(EzyPacket packet) {
        this.executeSendingPacket(packet, null);
    }

    public void addDroppedPacket(EzyPacket packet) {
        this.networkStats.addDroppedOutPackets(1L);
        this.networkStats.addDroppedOutBytes((long)packet.getSize());
    }

    protected final void handleReceivedData(Object data, int dataSize) {
        boolean hasMaxRequestPerSecond = this.session.addReceivedRequests(1);
        if (hasMaxRequestPerSecond) {
            this.handler.processMaxRequestPerSecond();
            this.networkStats.addDroppedInPackets(1L);
            this.networkStats.addDroppedInBytes((long)dataSize);
            this.logger.debug("request queue of session: {} is full, drop incoming request", (Object)this.session);
            return;
        }
        if (!this.session.isActivated()) {
            this.logger.debug("session: {} maybe destroyed, drop incoming request", (Object)this.session);
            return;
        }
        EzySocketRequest request = this.newSocketRequest(data);
        boolean success = this.sessionTicketsRequestQueues.addRequest(request);
        if (!success) {
            this.networkStats.addDroppedInPackets(1L);
            this.networkStats.addDroppedInBytes((long)dataSize);
            this.logger.info("request queue is full, drop incoming request");
        }
    }

    private EzySocketRequest newSocketRequest(Object data) {
        return new EzySimpleSocketRequest((EzySession)this.session, (EzyArray)data);
    }

    protected final void executeSendingPacket(EzyPacket packet, Object writeBuffer) {
        try {
            if (this.session.isActivated() && this.channel.isConnected()) {
                EzyConstant transportType = packet.getTransportType();
                int writeBytes = transportType == EzyTransportType.TCP ? this.writePacketToSocket(packet, writeBuffer) : this.writeUdpPacketToSocket(packet, writeBuffer);
                this.executeAddWrittenBytes(writeBytes);
            }
        }
        catch (Exception e) {
            int packetSize = packet.getSize();
            this.networkStats.addWriteErrorPackets(1L);
            this.networkStats.addWriteErrorBytes((long)packetSize);
            this.logger.info("can't send {} bytes to session: {}", new Object[]{packetSize, this.session, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writePacketToSocket(EzyPacket packet, Object writeBuffer) throws Exception {
        try {
            Object bytes = packet.getData();
            int writeBytes = this.channel.write(bytes, packet.isBinary());
            packet.release();
            int n = writeBytes;
            return n;
        }
        finally {
            packet.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeUdpPacketToSocket(EzyPacket packet, Object writeBuffer) throws Exception {
        try {
            EzyDatagramChannelPool udpChannelPool = this.session.getDatagramChannelPool();
            if (udpChannelPool == null) {
                int n = 0;
                return n;
            }
            SocketAddress clientAddress = this.session.getUdpClientAddress();
            if (clientAddress == null) {
                int n = 0;
                return n;
            }
            byte[] bytes = this.getBytesToWrite(packet);
            int bytesToWrite = bytes.length;
            ByteBuffer buffer = this.getWriteBuffer((ByteBuffer)writeBuffer, bytesToWrite);
            buffer.clear();
            buffer.put(bytes);
            buffer.flip();
            DatagramChannel channel = udpChannelPool.getChannel();
            int n = channel.send(buffer, clientAddress);
            return n;
        }
        finally {
            packet.release();
        }
    }

    protected byte[] getBytesToWrite(EzyPacket packet) {
        return (byte[])packet.getData();
    }

    protected ByteBuffer getWriteBuffer(ByteBuffer fixed, int bytesToWrite) {
        return bytesToWrite > fixed.capacity() ? ByteBuffer.allocate(bytesToWrite) : fixed;
    }

    protected final void executeAddReadBytes(int bytes) {
        this.statsThreadPool.execute(() -> this.addReadBytes(bytes));
    }

    private void executeAddWrittenBytes(int bytes) {
        this.statsThreadPool.execute(() -> this.addWrittenBytes(bytes));
    }

    private void addReadBytes(int count) {
        try {
            this.session.addReadBytes(count);
            this.networkStats.addReadBytes((long)count);
            this.networkStats.addReadPackets(1L);
        }
        catch (Throwable e) {
            this.logger.info("add ready bytes error", e);
        }
    }

    private void addWrittenBytes(int count) {
        try {
            this.session.addWrittenBytes(count);
            this.networkStats.addWrittenBytes((long)count);
            this.networkStats.addWrittenPackets(1L);
        }
        catch (Throwable e) {
            this.logger.info("add written bytes error", e);
        }
    }

    public EzyNioSession getSession() {
        return this.session;
    }

    public void destroy() {
        EzyProcessor.processWithLogException(() -> this.decoder.destroy());
        EzyProcessor.processWithLogException(() -> ((EzyNioDataHandler)this.handler).destroy());
    }

    @Generated
    public EzyChannel getChannel() {
        return this.channel;
    }

    public static abstract class Builder
    implements EzyBuilder<EzyHandlerGroup> {
        protected AtomicInteger sessionCount;
        protected EzySessionStats sessionStats;
        protected EzyNetworkStats networkStats;
        protected ExecutorService statsThreadPool;
        protected Object decoder;
        protected EzyNioSession session;
        protected EzyServerContext serverContext;
        protected EzySocketStreamQueue streamQueue;
        protected EzySessionTicketsQueue sessionTicketsQueue;
        protected EzySocketDisconnectionQueue disconnectionQueue;
        protected EzySessionTicketsRequestQueues sessionTicketsRequestQueues;

        public Builder decoder(Object decoder) {
            this.decoder = decoder;
            return this;
        }

        public Builder session(EzyNioSession session) {
            this.session = session;
            return this;
        }

        public Builder sessionCount(AtomicInteger sessionCount) {
            this.sessionCount = sessionCount;
            return this;
        }

        public Builder sessionStats(EzySessionStats sessionStats) {
            this.sessionStats = sessionStats;
            return this;
        }

        public Builder networkStats(EzyNetworkStats networkStats) {
            this.networkStats = networkStats;
            return this;
        }

        public Builder statsThreadPool(ExecutorService statsThreadPool) {
            this.statsThreadPool = statsThreadPool;
            return this;
        }

        public Builder serverContext(EzyServerContext serverContext) {
            this.serverContext = serverContext;
            return this;
        }

        public Builder streamQueue(EzySocketStreamQueue streamQueue) {
            this.streamQueue = streamQueue;
            return this;
        }

        public Builder sessionTicketsQueue(EzySessionTicketsQueue queue) {
            this.sessionTicketsQueue = queue;
            return this;
        }

        public Builder disconnectionQueue(EzySocketDisconnectionQueue disconnectionQueue) {
            this.disconnectionQueue = disconnectionQueue;
            return this;
        }

        public Builder sessionTicketsRequestQueues(EzySessionTicketsRequestQueues sessionTicketsRequestQueues) {
            this.sessionTicketsRequestQueues = sessionTicketsRequestQueues;
            return this;
        }

        protected boolean isStreamingEnable() {
            return this.serverContext.getServer().getSettings().getStreaming().isEnable();
        }
    }
}

