/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.database.query;

import com.tvd12.ezydata.database.exception.EzyCreateQueryException;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyStrings;
import java.util.function.Function;
import lombok.Generated;

public class EzyQLQuery {
    protected final String query;
    protected final String value;
    protected final Object[] parameters;
    protected final Function<Object, Object> parameterConverter;
    protected static final Object[] EMPTY_ARRAY = new Object[0];

    protected EzyQLQuery(Builder builder) {
        this.query = builder.query;
        this.parameterConverter = this.getParameterConverter(builder);
        this.parameters = builder.parameters != null ? builder.parameters : EMPTY_ARRAY;
        this.value = this.createValue();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected String createValue() {
        try {
            return EzyStrings.replace((String)this.query, (Object[])this.parameters, this.parameterConverter);
        }
        catch (Exception e) {
            throw new EzyCreateQueryException("can not create query", e);
        }
    }

    protected Function<Object, Object> getParameterConverter(Builder builder) {
        return builder.parameterConverter;
    }

    public String toString() {
        return "query: " + this.query + "\nparameters: " + EzyStrings.join((Object[])this.parameters, (String)",") + "\nvalue: " + this.value;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    public static class Builder
    implements EzyBuilder<EzyQLQuery> {
        protected String query;
        protected Object[] parameters;
        protected Function<Object, Object> parameterConverter;

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder parameterCount(int count) {
            if (this.parameters == null) {
                this.parameters = new Object[count];
            } else if (this.parameters.length < count) {
                Object[] old = this.parameters;
                this.parameters = new Object[count];
                System.arraycopy(old, 0, this.parameters, 0, old.length);
            }
            return this;
        }

        public Builder parameter(int index, boolean value) {
            return this.parameter(index, (Object)value);
        }

        public Builder parameter(int index, byte value) {
            return this.parameter(index, (Object)value);
        }

        public Builder parameter(int index, char value) {
            return this.parameter(index, Character.valueOf(value));
        }

        public Builder parameter(int index, double value) {
            return this.parameter(index, (Object)value);
        }

        public Builder parameter(int index, float value) {
            return this.parameter(index, Float.valueOf(value));
        }

        public Builder parameter(int index, int value) {
            return this.parameter(index, (Object)value);
        }

        public Builder parameter(int index, long value) {
            return this.parameter(index, (Object)value);
        }

        public Builder parameter(int index, short value) {
            return this.parameter(index, (Object)value);
        }

        public Builder parameter(int index, Object value) {
            this.parameterCount(index + 1);
            this.parameters[index] = value;
            return this;
        }

        public Builder parameterConverter(Function<Object, Object> parameterConverter) {
            this.parameterConverter = parameterConverter;
            return this;
        }

        public EzyQLQuery build() {
            return new EzyQLQuery(this);
        }
    }
}

