/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.socket.settings;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.core.json.ObjectMapperBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.socket.settings.ModuleMetadata;

public class SocketModuleMetadataReader
extends EzyLoggable {
    private static final Map<ModuleType, String> METADATA_FILES = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)ModuleType.SOCKET_APP, (Object)"socket/apps.txt").put((Object)ModuleType.SOCKET_PLUGIN, (Object)"socket/plugins.txt").build());

    public Map<String, ModuleMetadata> readModuleMetadataMap(String ezyplatformHome, ModuleType moduleType) {
        File runtimeFolder = FileSystemManager.concatWithEzyHome((String)ezyplatformHome, (String)".runtime");
        File modulesFile = this.getModuleMetadataFile(runtimeFolder, moduleType);
        ModuleMetadata[] moduleMetadataArray = modulesFile.exists() ? this.readModuleMetadata(modulesFile) : new ModuleMetadata[]{};
        return Arrays.stream(moduleMetadataArray).collect(Collectors.toMap(ModuleMetadata::getName, it -> it));
    }

    private ModuleMetadata[] readModuleMetadata(File metadataFile) {
        try {
            return (ModuleMetadata[])new ObjectMapperBuilder().build().readValue(metadataFile, ModuleMetadata[].class);
        }
        catch (IOException e) {
            return new ModuleMetadata[0];
        }
    }

    private File getModuleMetadataFile(File runtimeFolder, ModuleType moduleType) {
        return Paths.get(runtimeFolder.toString(), METADATA_FILES.get(moduleType)).toFile();
    }
}

