/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.function.EzyToObject;
import com.tvd12.ezyfox.io.EzyDataConverter;
import com.tvd12.ezyfox.io.EzyDates;
import com.tvd12.ezyfox.io.EzyNumbersConverter;
import com.tvd12.ezyfox.io.EzyOutputTransformer;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.security.EzyBase64;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class EzySimpleOutputTransformer
extends EzyLoggable
implements EzyOutputTransformer {
    private static final long serialVersionUID = 8067491929651725682L;
    protected final Map<Class, EzyToObject> transformers = this.defaultTransformers();

    @Override
    public Object transform(Object value, Class type) {
        return value == null ? this.transformNullValue() : this.transformNonNullValue(value, type);
    }

    protected Object transformNullValue() {
        return null;
    }

    protected Object transformNonNullValue(Object value, Class type) {
        return this.transformNonNullValue(value, type, this.transformers);
    }

    protected Object transformNonNullValue(Object value, Class type, Map<Class, EzyToObject> transformers) {
        EzyToObject trans = transformers.get(type);
        if (trans != null) {
            return trans.transform(value);
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value.toString());
        }
        return value;
    }

    private Map<Class, EzyToObject> defaultTransformers() {
        ConcurrentHashMap<Class, EzyToObject> answer = new ConcurrentHashMap<Class, EzyToObject>();
        this.addOtherTransformers(answer);
        this.addEntityTransformers(answer);
        this.addWrapperTransformers(answer);
        this.addPrimitiveTransformers(answer);
        this.addWrapperArrayTransformers(answer);
        this.addPrimitiveArrayTransformers(answer);
        this.addTwoDimensionsWrapperArrayTransformers(answer);
        this.addTwoDimensionsPrimitiveArrayTransformers(answer);
        return answer;
    }

    protected EzyObject[] toObjectArray(EzyArray value) {
        EzyObject[] answer = new EzyObject[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            answer[i] = value.get(i, EzyObject.class);
        }
        return answer;
    }

    protected void addPrimitiveTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean.TYPE, value -> value);
        answer.put(Byte.TYPE, Number::byteValue);
        answer.put(Character.TYPE, EzyNumbersConverter::objectToChar);
        answer.put(Double.TYPE, Number::doubleValue);
        answer.put(Float.TYPE, Number::floatValue);
        answer.put(Integer.TYPE, Number::intValue);
        answer.put(Long.TYPE, Number::longValue);
        answer.put(Short.TYPE, Number::shortValue);
    }

    protected void addWrapperTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean.class, value -> value);
        answer.put(Byte.class, Number::byteValue);
        answer.put(Character.class, EzyNumbersConverter::objectToChar);
        answer.put(Double.class, Number::doubleValue);
        answer.put(Float.class, Number::floatValue);
        answer.put(Integer.class, Number::intValue);
        answer.put(Long.class, Number::longValue);
        answer.put(Short.class, Number::shortValue);
        answer.put(String.class, value -> value);
    }

    protected void addPrimitiveArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(boolean[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToPrimitiveBoolArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Boolean.TYPE);
        });
        answer.put(byte[].class, value -> {
            if (value instanceof byte[]) {
                return value;
            }
            if (value instanceof String) {
                return EzyBase64.decode((String)((String)value));
            }
            return ((EzyArray)value).toArray(Byte.TYPE);
        });
        answer.put(char[].class, value -> {
            if (value instanceof byte[]) {
                return EzyDataConverter.byteArrayToCharArray((byte[])((byte[])value));
            }
            if (value instanceof String) {
                return ((String)value).toCharArray();
            }
            return ((EzyArray)value).toArray(Character.TYPE);
        });
        answer.put(double[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToPrimitiveDoubleArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Double.TYPE);
        });
        answer.put(float[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToPrimitiveFloatArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Float.TYPE);
        });
        answer.put(int[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToPrimitiveIntArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Integer.TYPE);
        });
        answer.put(long[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToPrimitiveLongArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Long.TYPE);
        });
        answer.put(short[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToPrimitiveShortArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Short.TYPE);
        });
        answer.put(String[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToStringArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(String.class);
        });
    }

    protected void addWrapperArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToWrapperBoolArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Boolean.class);
        });
        answer.put(Byte[].class, value -> {
            if (value instanceof byte[]) {
                return EzyDataConverter.toByteWrapperArray((byte[])((byte[])value));
            }
            return ((EzyArray)value).toArray(Byte.class);
        });
        answer.put(Character[].class, value -> {
            if (value instanceof byte[]) {
                return EzyDataConverter.toCharWrapperArray((byte[])((byte[])value));
            }
            return ((EzyArray)value).toArray(Character.class);
        });
        answer.put(Double[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToWrapperDoubleArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Double.class);
        });
        answer.put(Float[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToWrapperFloatArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Float.class);
        });
        answer.put(Integer[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToWrapperIntArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Integer.class);
        });
        answer.put(Long[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToWrapperLongArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Long.class);
        });
        answer.put(Short[].class, value -> {
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToWrapperShortArray((Collection)((Collection)value));
            }
            return ((EzyArray)value).toArray(Short.class);
        });
    }

    protected void addOtherTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Date.class, value -> {
            try {
                return EzyDates.parseToDateOrNull((Object)value);
            }
            catch (Exception e) {
                this.logger.info("Date value: {} is invalid", value, (Object)e);
                return null;
            }
        });
        answer.put(Instant.class, value -> {
            try {
                return EzyDates.parseToInstantOrNull((Object)value);
            }
            catch (Exception e) {
                this.logger.info("Date value: {} is invalid", value, (Object)e);
                return null;
            }
        });
        answer.put(LocalDate.class, value -> {
            try {
                return EzyDates.parseToLocalDateOrNull((Object)value);
            }
            catch (Exception e) {
                this.logger.info("LocalDate value: {} is invalid", value, (Object)e);
                return null;
            }
        });
        answer.put(LocalTime.class, value -> {
            try {
                return EzyDates.parseToLocalTimeOrNull((Object)value);
            }
            catch (Exception e) {
                this.logger.info("LocalTime value: {} is invalid", value, (Object)e);
                return null;
            }
        });
        answer.put(LocalDateTime.class, value -> {
            try {
                return EzyDates.parseToLocalDateTimeOrNull((Object)value);
            }
            catch (Exception e) {
                this.logger.info("LocalDateTime value : {} is invalid", value, (Object)e);
                return null;
            }
        });
        answer.put(Class.class, value -> {
            try {
                return EzyClasses.getClass((String)value);
            }
            catch (Exception e) {
                this.logger.info("Class value: {} is invalid", value, (Object)e);
                return null;
            }
        });
        answer.put(BigInteger.class, value -> {
            if (value instanceof BigInteger) {
                return value;
            }
            return new BigInteger((String)value);
        });
        answer.put(BigDecimal.class, value -> {
            if (value instanceof BigDecimal) {
                return value;
            }
            return new BigDecimal((String)value);
        });
        answer.put(UUID.class, value -> {
            if (value instanceof UUID) {
                return value;
            }
            return UUID.fromString((String)value);
        });
    }

    protected void addEntityTransformers(Map<Class, EzyToObject> answer) {
        answer.put(EzyObject[].class, this::toObjectArray);
        answer.put(EzyObject[][].class, value -> {
            EzyObject[][] answer1 = new EzyObject[value.size()][];
            for (int i = 0; i < value.size(); ++i) {
                answer1[i] = this.toObjectArray(value.get(i, EzyArray.class));
            }
            return answer1;
        });
    }

    protected void addTwoDimensionsPrimitiveArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(boolean[][].class, value -> value.toArray(boolean[].class));
        answer.put(byte[][].class, value -> value.toArray(byte[].class));
        answer.put(char[][].class, value -> value.toArray(char[].class));
        answer.put(double[][].class, value -> value.toArray(double[].class));
        answer.put(float[][].class, value -> value.toArray(float[].class));
        answer.put(int[][].class, value -> value.toArray(int[].class));
        answer.put(long[][].class, value -> value.toArray(long[].class));
        answer.put(short[][].class, value -> value.toArray(short[].class));
    }

    protected void addTwoDimensionsWrapperArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean[][].class, value -> value.toArray(Boolean[].class));
        answer.put(Byte[][].class, value -> value.toArray(Byte[].class));
        answer.put(Character[][].class, value -> value.toArray(Character[].class));
        answer.put(Double[][].class, value -> value.toArray(Double[].class));
        answer.put(Float[][].class, value -> value.toArray(Float[].class));
        answer.put(Integer[][].class, value -> value.toArray(Integer[].class));
        answer.put(Long[][].class, value -> value.toArray(Long[].class));
        answer.put(Short[][].class, value -> value.toArray(Short[].class));
        answer.put(String[][].class, value -> value.toArray(String[].class));
    }
}

