/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.thymeleaf;

import com.tvd12.ezyhttp.server.core.view.AbsentMessageResolver;
import com.tvd12.ezyhttp.server.core.view.MessageProvider;
import com.tvd12.ezyhttp.server.core.view.TemplateResolver;
import com.tvd12.ezyhttp.server.core.view.View;
import com.tvd12.ezyhttp.server.core.view.ViewContext;
import com.tvd12.ezyhttp.server.core.view.ViewDecorator;
import com.tvd12.ezyhttp.server.core.view.ViewDialect;
import com.tvd12.ezyhttp.server.core.view.ViewTemplateInputStreamLoader;
import com.tvd12.ezyhttp.server.thymeleaf.ThymeleafClassLoaderTemplateResolver;
import com.tvd12.ezyhttp.server.thymeleaf.ThymeleafMessageResolver;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nz.net.ultraq.thymeleaf.layoutdialect.LayoutDialect;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class ThymeleafViewContext
implements ViewContext {
    private final TemplateResolver metadata;
    private final TemplateEngine templateEngine;
    private final TemplateEngine contentTemplateEngine;
    private final List<ViewDialect> viewDialects;
    private final List<ViewDecorator> viewDecorators;
    private final List<MessageProvider> messageProviders;
    private final ThymeleafMessageResolver messageResolver;
    private final AbsentMessageResolver absentMessageResolver;
    private final List<ViewTemplateInputStreamLoader> templateInputStreamLoaders;

    public ThymeleafViewContext(TemplateResolver metadata, List<ViewDialect> viewDialects, List<ViewDecorator> viewDecorators, List<MessageProvider> messageProviders, AbsentMessageResolver absentMessageResolver, List<ViewTemplateInputStreamLoader> templateInputStreamLoaders) {
        this.metadata = metadata;
        this.viewDialects = viewDialects;
        this.viewDecorators = viewDecorators;
        this.messageProviders = messageProviders;
        this.absentMessageResolver = absentMessageResolver;
        this.templateInputStreamLoaders = templateInputStreamLoaders;
        this.messageResolver = this.createMessageResolver();
        this.templateEngine = this.createTemplateEngine();
        this.contentTemplateEngine = this.createContentTemplateEngine();
    }

    public void render(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, View view) throws IOException {
        for (ViewDecorator viewDecorator : this.viewDecorators) {
            viewDecorator.decorate(request, view);
        }
        Context context = new Context(view.getLocale(), view.getVariables());
        this.templateEngine.process(view.getTemplate(), (IContext)context, (Writer)response.getWriter());
    }

    public String renderHtml(View view) {
        Context context = new Context(view.getLocale(), view.getVariables());
        return this.renderHtml(context, view);
    }

    public String renderHtml(Object context, View view) {
        return this.contentTemplateEngine.process(view.getTemplate(), (IContext)context);
    }

    public String resolveMessage(Locale locale, String key, Object ... parameters) {
        String answer = this.messageResolver.resolveMessage(locale, key, parameters);
        if (answer == null) {
            answer = this.messageResolver.createAbsentMessageRepresentation(locale, key, parameters);
        }
        return answer;
    }

    private ThymeleafMessageResolver createMessageResolver() {
        return ThymeleafMessageResolver.builder().messageLocation(this.metadata.getMessagesLocation()).messageProviders(this.messageProviders).absentMessageResolver(this.absentMessageResolver).build();
    }

    private TemplateEngine createTemplateEngine() {
        ThymeleafClassLoaderTemplateResolver templateResolver = new ThymeleafClassLoaderTemplateResolver(this.templateInputStreamLoaders);
        TemplateMode templateMode = TemplateMode.valueOf((String)this.metadata.getTemplateMode());
        templateResolver.setTemplateMode(templateMode);
        templateResolver.setPrefix(this.metadata.getPrefix());
        templateResolver.setSuffix(this.metadata.getSuffix());
        templateResolver.setCharacterEncoding(this.metadata.getCharacterEncoding());
        templateResolver.setCacheTTLMs(Long.valueOf(this.metadata.getCacheTTLMs()));
        templateResolver.setCacheable(this.metadata.isCacheable());
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        templateEngine.setMessageResolver((IMessageResolver)this.messageResolver);
        templateEngine.addDialect((IDialect)new LayoutDialect());
        for (ViewDialect dialect : this.viewDialects) {
            if (!(dialect instanceof IDialect)) continue;
            templateEngine.addDialect((IDialect)dialect);
        }
        return templateEngine;
    }

    private TemplateEngine createContentTemplateEngine() {
        StringTemplateResolver resolver = new StringTemplateResolver();
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setCacheable(false);
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)resolver);
        templateEngine.setMessageResolver((IMessageResolver)this.messageResolver);
        templateEngine.addDialect((IDialect)new LayoutDialect());
        for (ViewDialect dialect : this.viewDialects) {
            if (!(dialect instanceof IDialect)) continue;
            templateEngine.addDialect((IDialect)dialect);
        }
        return templateEngine;
    }

    public ThymeleafMessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public TemplateEngine getContentTemplateEngine() {
        return this.contentTemplateEngine;
    }
}

