/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.installer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import org.youngmonkeys.ezyplatform.installer.constant.InstallerTargetType;
import org.youngmonkeys.ezyplatform.installer.io.InstallFolderProxy;
import org.youngmonkeys.ezyplatform.installer.io.InstallerBashRunner;
import org.youngmonkeys.ezyplatform.installer.io.InstallerFilesUpdater;
import org.youngmonkeys.ezyplatform.installer.io.InstallerHistoryWriter;
import org.youngmonkeys.ezyplatform.installer.io.InstallerUpdateFilesFetcher;
import org.youngmonkeys.ezyplatform.installer.util.InstallerTargetTypesDetector;

public class InstallerStartup {
    public static void main(String[] args) {
        try {
            InstallerHistoryWriter.writeToHistory("start ezyplatform installation");
            InstallerStartup.install();
            InstallerHistoryWriter.writeToHistory("finish ezyplatform installation");
        }
        catch (Throwable e) {
            InstallerHistoryWriter.writeToHistory("can not install ezyplatform, error: " + e.getClass().getName() + " (" + e.getMessage() + ")");
        }
    }

    private static void install() throws Exception {
        Set<String> updateFiles = InstallerUpdateFilesFetcher.getUpdateFiles();
        if (updateFiles.isEmpty()) {
            InstallerHistoryWriter.writeToHistory("there is no update files");
            return;
        }
        InstallerStartup.deleteNewModulesFile();
        Set<InstallerTargetType> targetTypes = InstallerTargetTypesDetector.detect(updateFiles);
        if (targetTypes.size() == 3) {
            InstallerHistoryWriter.writeToHistory("stop all targets");
            InstallerBashRunner.runBashFile("cli", "stop");
            InstallerHistoryWriter.writeToHistory("stop all targets successfully");
        } else {
            if (targetTypes.contains((Object)InstallerTargetType.SOCKET)) {
                InstallerHistoryWriter.writeToHistory("stop socket");
                InstallerBashRunner.runBashFile("cli", "stop socket");
                InstallerHistoryWriter.writeToHistory("stop socket successfully");
            }
            if (targetTypes.contains((Object)InstallerTargetType.WEB)) {
                InstallerHistoryWriter.writeToHistory("stop web");
                InstallerBashRunner.runBashFile("cli", "stop web");
                InstallerHistoryWriter.writeToHistory("stop web successfully");
            }
            InstallerHistoryWriter.writeToHistory("stop admin");
            InstallerBashRunner.runBashFile("cli", "stop admin");
            InstallerHistoryWriter.writeToHistory("stop admin successfully");
        }
        Thread.sleep(3000L);
        InstallerStartup.deleteCurrentFoldersOrWait(updateFiles);
        InstallerFilesUpdater.replaceNewFiles(updateFiles);
        if (targetTypes.size() == 3) {
            InstallerHistoryWriter.writeToHistory("start all targets");
            InstallerBashRunner.runBashFile("cli", "start");
            InstallerHistoryWriter.writeToHistory("start all targets successfully");
        } else {
            InstallerHistoryWriter.writeToHistory("start admin");
            InstallerBashRunner.runBashFile("cli", "start admin");
            InstallerHistoryWriter.writeToHistory("start admin successfully");
            Thread.sleep(3000L);
            if (targetTypes.contains((Object)InstallerTargetType.WEB)) {
                InstallerHistoryWriter.writeToHistory("start web");
                InstallerBashRunner.runBashFile("cli", "start web");
                InstallerHistoryWriter.writeToHistory("start web successfully");
            }
            if (targetTypes.contains((Object)InstallerTargetType.SOCKET)) {
                InstallerHistoryWriter.writeToHistory("start socket");
                InstallerBashRunner.runBashFile("cli", "start socket");
                InstallerHistoryWriter.writeToHistory("start socket successfully");
            }
        }
        InstallerHistoryWriter.writeToHistory("delete ezyplatform installation folder");
        InstallFolderProxy.deleteFolder(InstallFolderProxy.getUploadEzyPlatformFolder());
    }

    private static void deleteNewModulesFile() throws IOException {
        Path newModulesFilesPath = InstallFolderProxy.getNewModulesFilesPath();
        if (Files.exists(newModulesFilesPath, new LinkOption[0])) {
            Files.delete(newModulesFilesPath);
        }
    }

    private static void deleteCurrentFoldersOrWait(Set<String> updateFiles) throws Exception {
        int retryCount = 0;
        while (true) {
            try {
                InstallerFilesUpdater.deleteCurrentFolders(updateFiles);
            }
            catch (IOException e) {
                if (++retryCount > 30) {
                    throw e;
                }
                InstallerHistoryWriter.writeToHistory("delete current folders failed: " + e.getClass().getName() + " (" + e.getMessage() + "), retry count: " + retryCount);
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }
}

