/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.installer.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.youngmonkeys.ezyplatform.installer.constant.InstallerTargetType;

public final class InstallerTargetTypesDetector {
    private InstallerTargetTypesDetector() {
    }

    public static Set<InstallerTargetType> detect(Collection<String> updateFiles) {
        HashSet<String> nonTargetFiles = new HashSet<String>();
        HashSet<InstallerTargetType> targetTypes = new HashSet<InstallerTargetType>();
        for (String file : updateFiles) {
            if (file.startsWith("admin")) {
                targetTypes.add(InstallerTargetType.ADMIN);
            } else if (file.startsWith("web")) {
                targetTypes.add(InstallerTargetType.WEB);
            } else if (file.startsWith("socket")) {
                targetTypes.add(InstallerTargetType.SOCKET);
            } else {
                nonTargetFiles.add(file);
                break;
            }
            if (targetTypes.size() != 3) continue;
            break;
        }
        if (!nonTargetFiles.isEmpty()) {
            targetTypes.addAll(Arrays.asList(InstallerTargetType.values()));
        }
        return targetTypes;
    }
}

